<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Rescue extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('rescuesystem_model');
        $this->load->model('Rescue_model');
        hooks()->do_action('rescuesystem_init');
    }

    public function index()
    {
        $data['modules'] = $this->Rescue_model->get_modules();
        $rescueKeys = $this->Rescue_model->get_available_rescue_keys();

        $keys = [];
        foreach ($rescueKeys as $key) {
            $keys[] = $key['rescue_key'];
        }
        $data['rescueKeys'] = $keys;

        $rescue_key = $this->input->get('rescue_key', TRUE);

        if (!in_array($rescue_key, $keys)) {
            echo '
            <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 900px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        p {
            text-align: center;
            color: #555;
        }

        .modules-list {
            margin: 20px 0;
        }

        .modules-list ul {
            list-style: none;
            padding: 0;
        }

        .modules-list li {
            display: flex;
            justify-content: space-between;
            padding: 10px;
            border-bottom: 1px solid #e0e0e0;
            align-items: center;
        }

        .modules-list li:nth-child(even) {
            background-color: #f9f9f9;
        }

        .flash-message {
            padding: 15px;
            background-color: #28a745;
            color: #fff;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .flash-error {
            background-color: #dc3545;
        }

        .form-buttons {
            text-align: center;
            margin: 30px 0;
        }

        .form-buttons button {
            padding: 10px 20px;
            margin: 0 10px;
            border: none;
            border-radius: 5px;
            background-color: #007bff;
            color: white;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
            display: inline-block;
        }

        .form-buttons .deactivate-btn {
            background-color: #dc3545;
        }

        .form-buttons .activate-btn {
            background-color: #28a745;
        }

        .form-buttons .access-crm-btn {
            background-color: #007bff;
        }

        .form-buttons button:hover {
            opacity: 0.8;
        }

        .checkbox {
            display: flex;
            align-items: center;
        }

        .checkbox input {
            margin-right: 10px;
        }

        .checkbox label {
            cursor: pointer;
        }

        .badge {
            display: inline-block;
            padding: 5px 10px;
            font-size: 12px;
            font-weight: bold;
            color: #fff;
            border-radius: 10px;
        }

        .badge-active {
            background-color: #28a745;
        }

        .badge-inactive {
            background-color: #dc3545;
        }

        .key-form {
            text-align: center;
        }

        .key-form input {
            padding: 10px;
            margin: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .key-form button {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            background-color: #007bff;
            color: white;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .key-form button:hover {
            background-color: #0056b3;
        }

        @media (max-width: 768px) {
            .modules-list li {
                flex-direction: column;
                align-items: flex-start;
            }
        }
    </style>
            ';
            echo '<div class="container">';
            echo '<div class="key-form">';
            echo '<h1>Enter Rescue Key</h1>';
            echo '<form method="get" action="">';
            echo '<input type="text" name="rescue_key" placeholder="Enter Rescue Key">';
            echo '<button type="submit">Submit</button>';
            echo '</form>';
            echo '</div>';
            echo '</div>';
        } else {
            $this->session->set_userdata('rescue_key', $rescue_key);
            $this->Rescue_model->increment_total_uses($rescue_key);

            $this->load_external_view('rescuesystem/views/rescue', $data);
        }
    }

    public function disable_selected()
    {
        $module_ids = $this->input->post('module_ids');
        $rescue_key = $this->session->userdata('rescue_key');

        if ($this->Rescue_model->is_valid_rescue_key($rescue_key)) {
            $this->Rescue_model->disable_modules($module_ids);

            echo json_encode(['message' => 'Selected modules have been deactivated.']);
        } else {
            echo json_encode(['message' => 'Invalid rescue key.']);
        }
    }

    public function enable_selected()
    {
        $module_ids = $this->input->post('module_ids');
        $rescue_key = $this->session->userdata('rescue_key');

        if ($this->Rescue_model->is_valid_rescue_key($rescue_key)) {
            $this->Rescue_model->enable_modules($module_ids);

            echo json_encode(['message' => 'Selected modules have been activated.']);
        } else {
            echo json_encode(['message' => 'Invalid rescue key.']);
        }
    }

    private function load_external_view($view_file, $data)
    {
        $file_path = APP_MODULES_PATH . $view_file . '.php';

        if (file_exists($file_path)) {
            extract($data);
            include($file_path);
        } else {
            echo "View file not found: " . htmlspecialchars($file_path);
        }
    }
}
