<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Rescuesystem extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('rescuesystem_model');
        hooks()->do_action('rescuesystem_init');
    }

    public function index()
    {
        show_404();
    }

    public function manage()
    {
        if (!is_admin()) {
            access_denied('rescuesystem');
        }

        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data(module_views_path('rescuesystem', 'table'));
        }

        $data['title'] = _l('rescuesystem');
        $this->load->view('manage', $data);
    }

    public function create()
    {
        if (!is_admin()) {
            access_denied('rescuesystem');
        }

        $response = $this->rescuesystem_model->create([
            'rescue_url' => site_url('rescuesystem/rescue'),
            'rescue_key' => app_generate_hash(),
            'created_at' => date('Y-m-d H:i:s'),
        ]);

        if ($response == true) {
            set_alert('success', _l('rescuesystem_created_successfully'));
        } else {
            set_alert('warning', _l('rescuesystem_not_created_successfully'));
        }

        redirect(admin_url('rescuesystem/manage'));
    }

    public function delete($id = '')
    {
        if (!is_admin()) {
            access_denied('rescuesystem');
        }

        if (!$id) {
            redirect(admin_url('rescuesystem/manage'));
        }

        $this->rescuesystem_model->delete($id);

        set_alert('success', _l('deleted', _l('rescuesystem_key')));
        redirect(admin_url('rescuesystem/manage'));
    }

    public function download($id)
    {
        $rescueKeyData = $this->rescuesystem_model->get($id);

        $redirectUrl = $rescueKeyData->rescue_url . '/?rescue_key=' . $rescueKeyData->rescue_key;

        $htmlContent = '<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Redirect Page</title>
</head>
<body>
    <h1>Redirecting...</h1>
    <p>If you are not redirected automatically, follow this <a href="' . $redirectUrl . '">' . $redirectUrl . '</a>.</p>
    <script>
        setTimeout(function() {
            window.location.href = "' . $redirectUrl . '";
        }, 5000);
    </script>
</body>
</html>';

        $fileName = 'CRM-RescueKey-' . $rescueKeyData->rescue_key . '.html';

        header('Content-Type: text/html');
        header('Content-Disposition: attachment; filename="' . $fileName . '"');
        header('Content-Length: ' . strlen($htmlContent));

        echo $htmlContent;
        exit;
    }

}
