<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Rescue_model extends CI_Model
{
    public function get_modules()
    {
        return $this->db->get(db_prefix() . 'modules')->result_array();
    }

    public function disable_modules($module_ids)
    {
        $this->db->where_in('id', $module_ids);
        $this->db->update(db_prefix() . 'modules', ['active' => 0]);
    }

    public function enable_modules($module_ids)
    {
        $this->db->where_in('id', $module_ids);
        $this->db->update(db_prefix() . 'modules', ['active' => 1]);
    }

    public function get_available_rescue_keys()
    {
        return $this->db->get(db_prefix() . 'rescuesystem_keys')->result_array();
    }

    public function increment_total_uses($rescue_key)
    {
        $this->db->set('total_uses', 'total_uses+1', FALSE);
        $this->db->where('rescue_key', $rescue_key);
        $this->db->update(db_prefix() . 'rescuesystem_keys');
    }

    public function is_valid_rescue_key($rescue_key)
    {
        $this->db->where('rescue_key', $rescue_key);
        $query = $this->db->get(db_prefix() . 'rescuesystem_keys');

        return $query->num_rows() > 0;
    }

}
