<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Rescue Mode</title>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f9;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 900px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }

        h1 {
            text-align: center;
            color: #333;
        }

        p {
            text-align: center;
            color: #555;
        }

        .modules-list {
            margin: 20px 0;
        }

        .modules-list ul {
            list-style: none;
            padding: 0;
        }

        .modules-list li {
            display: flex;
            justify-content: space-between;
            padding: 10px;
            border-bottom: 1px solid #e0e0e0;
            align-items: center;
        }

        .modules-list li:nth-child(even) {
            background-color: #f9f9f9;
        }

        .flash-message {
            padding: 15px;
            background-color: #28a745;
            color: #fff;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 20px;
        }

        .flash-error {
            background-color: #dc3545;
        }

        .form-buttons {
            text-align: center;
            margin: 30px 0;
        }

        .form-buttons button {
            padding: 10px 20px;
            margin: 0 10px;
            border: none;
            border-radius: 5px;
            background-color: #007bff;
            color: white;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
            display: inline-block;
        }

        .form-buttons .deactivate-btn {
            background-color: #dc3545;
        }

        .form-buttons .activate-btn {
            background-color: #28a745;
        }

        .form-buttons .access-crm-btn {
            background-color: #007bff;
        }

        .form-buttons button:hover {
            opacity: 0.8;
        }

        .checkbox {
            display: flex;
            align-items: center;
        }

        .checkbox input {
            margin-right: 10px;
        }

        .checkbox label {
            cursor: pointer;
        }

        .badge {
            display: inline-block;
            padding: 5px 10px;
            font-size: 12px;
            font-weight: bold;
            color: #fff;
            border-radius: 10px;
        }

        .badge-active {
            background-color: #28a745;
        }

        .badge-inactive {
            background-color: #dc3545;
        }

        .key-form {
            text-align: center;
        }

        .key-form input {
            padding: 10px;
            margin: 10px;
            font-size: 16px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .key-form button {
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            background-color: #007bff;
            color: white;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s;
        }

        .key-form button:hover {
            background-color: #0056b3;
        }

        @media (max-width: 768px) {
            .modules-list li {
                flex-direction: column;
                align-items: flex-start;
            }
        }
    </style>
</head>
<body>

<div class="container">
    <?php
    $rescue_key = isset($_GET['rescue_key']) ? $_GET['rescue_key'] : '';

    if (!in_array($rescue_key, $rescueKeys)) {
        echo '<div class="key-form">';
        echo '<h1>Enter Rescue Key</h1>';
        echo '<form method="get" action="">';
        echo '<input type="text" name="rescue_key" placeholder="Enter Rescue Key">';
        echo '<button type="submit">Submit</button>';
        echo '</form>';
        echo '</div>';
    } else {
        ?>

        <h1>Rescue Mode</h1>
        <p>If you are experiencing issues, you can disable selected modules or all modules to troubleshoot.</p>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="flash-message"><?php echo $this->session->flashdata('success'); ?></div>
        <?php elseif ($this->session->flashdata('error')): ?>
            <div class="flash-message flash-error"><?php echo $this->session->flashdata('error'); ?></div>
        <?php endif; ?>

        <div class="form-buttons">
            <label class="checkbox">
                <input type="checkbox" id="hideDisabledModules">
                <span>Hide disabled modules from list</span>
            </label>
        </div>

        <div class="modules-list">
            <h3>Modules:</h3>
            <ul id="modulesList">
                <?php foreach ($modules as $module): ?>
                    <?php if ($module['module_name'] !== 'rescuesystem'): ?>
                        <li data-active="<?php echo $module['active']; ?>">
                            <label class="checkbox">
                                <input type="checkbox" name="module_ids[]" value="<?php echo $module['id']; ?>"
                                       id="module_<?php echo $module['id']; ?>" class="module-checkbox">
                                <?php echo ucfirst($module['module_name']); ?>
                            </label>
                            <span class="badge <?php echo $module['active'] ? 'badge-active' : 'badge-inactive'; ?>">
                                <?php echo $module['active'] ? 'Active' : 'Inactive'; ?>
                            </span>
                        </li>
                    <?php endif; ?>
                <?php endforeach; ?>
            </ul>

            <div class="form-buttons">
                <button type="button" class="deactivate-btn" id="disableSelected">Deactivate Selected Modules (0)
                </button>
                <button type="button" class="activate-btn" id="enableSelected">Activate Selected Modules (0)</button>
            </div>

            <div class="form-buttons">
                <a href="<?php echo base_url('admin/dashboard'); ?>" target="_blank">
                    <button class="access-crm-btn">Access CRM</button>
                </a>
            </div>
        </div>

    <?php } ?>

</div>

</body>
<script>
    $(document).ready(function () {
        function updateSelectedCount() {
            var selectedCount = $('.module-checkbox:checked').length;
            $('#disableSelected').text('Deactivate Selected Modules (' + selectedCount + ')');
            $('#enableSelected').text('Activate Selected Modules (' + selectedCount + ')');
        }

        function toggleDisabledModules() {
            var hideDisabled = $('#hideDisabledModules').is(':checked');
            $('#modulesList li').each(function () {
                var isActive = $(this).data('active');
                if (!isActive && hideDisabled) {
                    $(this).hide();
                } else {
                    $(this).show();
                }
            });
        }

        updateSelectedCount();
        toggleDisabledModules();

        $('.module-checkbox').change(function () {
            updateSelectedCount();
        });

        $('#hideDisabledModules').change(function () {
            toggleDisabledModules();
        });

        $('#disableSelected').click(function () {
            var moduleIds = [];
            $('.module-checkbox:checked').each(function () {
                moduleIds.push($(this).val());
            });

            if (moduleIds.length > 0) {
                $.ajax({
                    url: '<?php echo base_url("rescuesystem/rescue/disable_selected"); ?>',
                    type: 'POST',
                    data: {
                        module_ids: moduleIds,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        alert(response.message);
                        location.reload();
                    },
                    error: function (xhr) {
                        alert('An error occurred: ' + xhr.responseText);
                    }
                });
            } else {
                alert('Please select at least one module to deactivate.');
            }
        });

        $('#enableSelected').click(function () {
            var moduleIds = [];
            $('.module-checkbox:checked').each(function () {
                moduleIds.push($(this).val());
            });

            if (moduleIds.length > 0) {
                $.ajax({
                    url: '<?php echo base_url("rescuesystem/rescue/enable_selected"); ?>',
                    type: 'POST',
                    data: {
                        module_ids: moduleIds,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    success: function (response) {
                        response = JSON.parse(response);
                        alert(response.message);
                        location.reload();
                    },
                    error: function (xhr) {
                        alert('An error occurred: ' + xhr.responseText);
                    }
                });
            } else {
                alert('Please select at least one module to activate.');
            }
        });
    });
</script>
</html>
