<?php

defined('BASEPATH') or exit('No direct script access allowed');
/**
 * Team password client controller
 */
class Team_password_client extends ClientsController
{
  public function __construct()
  {
    parent::__construct();
    $this->load->model('team_password_model');
  }
      /**
     * team password management
     * @return view
     */
      public function team_password_mgt(){
        if (!is_client_logged_in()) {
          redirect(site_url('authentication/login'));
        }

        $contact_id = get_contact_user_id();
        $data_contact = $this->team_password_model->get_contact($contact_id);
        $data['share'] = [];

        $data['type'] = $this->input->get('type');
        $data['cate'] = $this->input->get('cate');
        if(!$data['type']){
          $data['type'] = 'all_password';
        }

        if(!$data['cate']){
          $data['cate'] = 'all';
        }

        if($data_contact && isset($data_contact->email)){
          $email = $data_contact->email;
          if($email){
            $data['share'] = $this->team_password_model->get_data_share($email, get_client_user_id(), $data['cate'], $data['type']);
          }

          $data['tree_cate'] = json_encode($this->team_password_model->get_tree_data_cate_contact($data['type'],$data['cate'], $email, get_client_user_id()));        
        }

        $data['title'] = _l('team_password');
        $this->data($data);
        $this->view('team_password_mgt/client/team_password_mgt');
        $this->layout();
      }
     /**
     * view share client
     * @param string $hash
     * @param string $type
     * @return view       
     */
     public function view_share_client($hash, $type = ''){
      $data_share = $this->team_password_model->get_tp_share_hash($hash);
      if($data_share){
        $data['r'] = $data_share->r;
        $data['w'] = $data_share->w;
        $data['share_id'] = $data_share->share_id;
        $data['effective_time'] = $data_share->effective_time;
        $data['unlimited'] = $data_share->unlimited;

        if($data_share->not_in_the_system == 'off'){
            if(!is_client_logged_in()){
              redirect(site_url('authentication/login'));
            }
        }

        if( strtotime($data['effective_time'] ?? '')<=strtotime(date('Y-m-d H:i:s') ?? '') && $data['unlimited'] != 1){ 
          error_page(_l('team_password'),'<i class="fa fa-clock-o" aria-hidden="true"></i> '._l('this_page_has_expired'));  
        }
        else{

          $data['type'] = $data_share->type;
          switch ($data['type']) {
            case 'normal':
            $data['normal'] = $this->team_password_model->get_normal($data['share_id']);

            $name = '';     
            if($data['normal']){          
              if($data['normal']->enable_log == 'on'){
                $name = $data['normal']->name;
                $data['title'] = $name;
                $data['id'] = $data['share_id'];

                if(is_staff_logged_in()){
                  $this->data($data);
                  $this->view('team_password_mgt/client/view_normal_client');
                  $this->layout();
                }else{

                  if(($data['r'] == 'on' && $data['w'] == 'on')||($data['w'] == 'on')){
                    if (!is_client_logged_in() && !is_staff_logged_in()) {
                      $data['category'] = [];
                    }else{
                      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
                    }
                    $this->data($data);
                    $this->view('team_password_mgt/client/edit_normal_client');
                    $this->layout();
                  }
                  elseif($data['r'] == 'on'){
                    $this->data($data);
                    $this->view('team_password_mgt/client/view_normal_client');
                    $this->layout();                
                  }else{        
                    error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
                  }
                }
              } 
              else{
               error_page(_l('team_password'),'<i class="fa fa-pause-circle" aria-hidden="true"></i> '._l('this_page_has_not_been_activated'));
             }      
           }  
           else{        
            error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
          }
          break;  
          case 'bank_account':
          $data['bank_account'] = $this->team_password_model->get_bank_account($data['share_id']);
          $name = '';     
          if($data['bank_account']){          
            if($data['bank_account']->enable_log == 'on'){


              $name = $data['bank_account']->name;
              $data['title'] = $name;
              $data['id'] = $data['share_id'];

              if(is_staff_logged_in()){
                $this->data($data);
                $this->view('team_password_mgt/client/view_bank_account_client');
                $this->layout();
              }else{

                if(($data['r'] == 'on' && $data['w'] == 'on')||($data['w'] == 'on')){
                  if (!is_client_logged_in() && !is_staff_logged_in()) {
                      $data['category'] = [];
                    }else{
                      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
                    }
                  $this->data($data);
                  $this->view('team_password_mgt/client/edit_bank_account_client');
                  $this->layout();
                }
                elseif($data['r'] == 'on'){
                  $this->data($data);
                  $this->view('team_password_mgt/client/view_bank_account_client');
                  $this->layout();                
                }
              }
            } 
            else{
              error_page(_l('team_password'),'<i class="fa fa-pause-circle" aria-hidden="true"></i> '._l('this_page_has_not_been_activated'));
            }      
          }  
          else{
           error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
         }
         break; 
         case 'credit_card':
         $data['credit_card'] = $this->team_password_model->get_credit_card($data['share_id']);
         $name = '';     
         if($data['credit_card']){          
          if($data['credit_card']->enable_log == 'on'){


            $name = $data['credit_card']->name;
            $data['title'] = $name;
            $data['id'] = $data['share_id'];

            if(is_staff_logged_in()){
              $this->data($data);
              $this->view('team_password_mgt/client/view_credit_card_client');
              $this->layout();
            }else{

              if(($data['r'] == 'on' && $data['w'] == 'on')||($data['w'] == 'on')){
                if (!is_client_logged_in() && !is_staff_logged_in()) {
                      $data['category'] = [];
                    }else{
                      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
                    }
                $this->data($data);
                $this->view('team_password_mgt/client/edit_credit_card_client');
                $this->layout();
              }
              elseif($data['r'] == 'on'){
                $this->data($data);
                $this->view('team_password_mgt/client/view_credit_card_client');
                $this->layout();                
              }
            }
          } 
          else{
            error_page(_l('team_password'),'<i class="fa fa-pause-circle" aria-hidden="true"></i> '._l('this_page_has_not_been_activated'));
          }      
        }  
        else{
         error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
       }
       break; 
       case 'email':
       $data['email'] = $this->team_password_model->get_email($data['share_id']);
       $name = '';     
       if($data['email']){          
        if($data['email']->enable_log == 'on'){


          $name = $data['email']->name;
          $data['title'] = $name;
          $data['id'] = $data['share_id'];

          if(is_staff_logged_in()){
            $this->data($data);
            $this->view('team_password_mgt/client/view_email_client');
            $this->layout(); 
          }else{

            if(($data['r'] == 'on' && $data['w'] == 'on')||($data['w'] == 'on')){
              if (!is_client_logged_in() && !is_staff_logged_in()) {
                      $data['category'] = [];
                    }else{
                      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
                    }
              $this->data($data);
              $this->view('team_password_mgt/client/edit_email_client');
              $this->layout();
            }
            elseif($data['r'] == 'on'){
              $this->data($data);
              $this->view('team_password_mgt/client/view_email_client');
              $this->layout();                
            }
          }
        } 
        else{
          error_page(_l('team_password'),'<i class="fa fa-pause-circle" aria-hidden="true"></i> '._l('this_page_has_not_been_activated'));
        }      
      }  
      else{
       error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
     }
     break; 
     case 'server':
     $data['server'] = $this->team_password_model->get_server($data['share_id']);
     $name = '';     
     if($data['server']){          
      if($data['server']->enable_log == 'on'){


        $name = $data['server']->name;
        $data['title'] = $name;
        $data['id'] = $data['share_id'];
        if(is_staff_logged_in()){
          $this->data($data);
          $this->view('team_password_mgt/client/view_server_client');
          $this->layout(); 
        }else{

          if(($data['r'] == 'on' && $data['w'] == 'on')||($data['w'] == 'on')){
           if (!is_client_logged_in() && !is_staff_logged_in()) {
                      $data['category'] = [];
                    }else{
                      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
                    }
            $this->data($data);
            $this->view('team_password_mgt/client/edit_server_client');
            $this->layout();
          }
          elseif($data['r'] == 'on'){
            $this->data($data);
            $this->view('team_password_mgt/client/view_server_client');
            $this->layout();                
          }
        }
      } 
      else{
        error_page(_l('team_password'),'<i class="fa fa-pause-circle" aria-hidden="true"></i> '._l('this_page_has_not_been_activated'));
      }      
    }  
    else{
     error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
   }
   break; 
   case 'software_license':
   $data['software_license'] = $this->team_password_model->get_software_license($data['share_id']);
   $name = '';     
   if($data['software_license']){          
    if($data['software_license']->enable_log == 'on'){


      $name = $data['software_license']->name;
      $data['title'] = $name;
      $data['id'] = $data['share_id'];
      if(is_staff_logged_in()){
        $this->data($data);
        $this->view('team_password_mgt/client/view_software_license_client');
        $this->layout();      
      }else{

        if(($data['r'] == 'on' && $data['w'] == 'on')||($data['w'] == 'on')){
          if (!is_client_logged_in() && !is_staff_logged_in()) {
                      $data['category'] = [];
                    }else{
                      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
                    }
          $this->data($data);
          $this->view('team_password_mgt/client/edit_software_license_client');
          $this->layout();
        }
        elseif($data['r'] == 'on'){
          $this->data($data);
          $this->view('team_password_mgt/client/view_software_license_client');
          $this->layout();                
        }
      }
    } 
    else{
      error_page(_l('team_password'),'<i class="fa fa-pause-circle" aria-hidden="true"></i> '._l('this_page_has_not_been_activated'));
    }      
  }  
  else{
   error_page(_l('team_password'),'<i class="fa fa-database" aria-hidden="true"></i> '._l('this_page_data_does_not_exist'));
 }
 break; 

}
}      
}
else{
  die;
}
}
     /**
     * add normal
     * @param id
     * @return redirect
     */
     public function add_normal($id = '')
     {
      if (!is_client_logged_in()) {
        redirect(site_url('authentication/login'));
      }

      $cate = $this->input->get('cate');

      if($cate != 'all' && $cate != ''){
        $data['cate'] = $cate;
      }else{
        $data['cate'] = '';
      }

      $data['title'] = _l('add_normal');
      if ($this->input->post()) {
        $message          = '';
        $data             = $this->input->post();
        $data['enable_log'] = 'on';
        if (!$data['id'] == '') {
          $data['password'] = $this->input->post('password' , false);
          $success = $this->team_password_model->update_normal($data);
          if ($success) {
            $message = _l('updated_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=normal'));
        }else{
          if(get_option('contact_can_add_password') != 1){
            access_denied('team_password');
          }

          $data['add_by'] = 'contact';
          $data['add_from'] = get_contact_user_id();
          $data['password'] = $this->input->post('password' , false);
          $insert_id = $this->team_password_model->add_normal($data);
          if ($insert_id) {
            $success = true;
            $message = _l('added_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=normal'));
        }
      }

      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
      $this->data($data);
      $this->view('team_password_mgt/client/edit_normal_client');
      $this->layout();
    }
      /**
     * add bank account
     * @param id
     * @return redirect
     */
      public function add_bank_account($id = '')
      {   
        if (!is_client_logged_in()) {
          redirect(site_url('authentication/login'));
        }

        $cate = $this->input->get('cate');

        if($cate != 'all' && $cate != ''){
          $data['cate'] = $cate;
        }else{
          $data['cate'] = '';
        }

        $data['title'] = _l('add_bank_account');
        if ($this->input->post()) {
          $message          = '';
          $data             = $this->input->post();
          $data['enable_log'] = 'on';
          if ($data['id'] == '') {

            if(get_option('contact_can_add_password') != 1){
              access_denied('team_password');
            }

            $data['add_by'] = 'contact';
            $data['add_from'] = get_contact_user_id();
            $data['pin'] = $this->input->post('pin' , false);
            $insert_id = $this->team_password_model->add_bank_account($data);
            if ($insert_id) {
              $success = true;
              $message = _l('added_successfully');
              set_alert('success', $message);
            }
            redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=bank_account'));
          } else {
            $data['pin'] = $this->input->post('pin' , false);
            $success = $this->team_password_model->update_bank_account($data);
            if ($success) {
              $message = _l('updated_successfully');
              set_alert('success', $message);
            }
            redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=bank_account'));
          }
          die;
        }

        $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
        $this->data($data);
        $this->view('team_password_mgt/client/edit_bank_account_client');
        $this->layout();
      }
      /**
     * add credit card
     * @param id
     * @return redirect
     */
      public function add_credit_card($id = '')
      {   
        if (!is_client_logged_in()) {
          redirect(site_url('authentication/login'));
        }

        $cate = $this->input->get('cate');

        if($cate != 'all' && $cate != ''){
          $data['cate'] = $cate;
        }else{
          $data['cate'] = '';
        }

        $data['title'] = _l('add_credit_card');
        if ($this->input->post()) {
          $message          = '';
          $data             = $this->input->post();
          $data['enable_log'] = 'on';
          if ($data['id'] == '') {

            if(get_option('contact_can_add_password') != 1){
              access_denied('team_password');
            }

            $data['add_by'] = 'contact';
            $data['add_from'] = get_contact_user_id();
            $data['pin'] = $this->input->post('pin' , false);
            $insert_id = $this->team_password_model->add_credit_card($data);
            if ($insert_id) {
              $success = true;
              $message = _l('added_successfully');
              set_alert('success', $message);
            }
            redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=credit_card'));
          } else {
            $data['pin'] = $this->input->post('pin' , false);
            $success = $this->team_password_model->update_credit_card($data);
            if ($success) {
              $message = _l('updated_successfully');
              set_alert('success', $message);
            }
            redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=credit_card'));
          }
          die;
        }

        $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
        $this->data($data);
        $this->view('team_password_mgt/client/edit_credit_card_client');
        $this->layout();
      }

     /**
       * add email
       * @param id
       * @return redirect
      */
     public function add_email($id = '')
     {   
      if (!is_client_logged_in()) {
        redirect(site_url('authentication/login'));
      }

      $cate = $this->input->get('cate');

      if($cate != 'all' && $cate != ''){
        $data['cate'] = $cate;
      }else{
        $data['cate'] = '';
      }

      $data['title'] = _l('add_email');
      if ($this->input->post()) {
        $message          = '';
        $data             = $this->input->post();
        $data['enable_log'] = 'on';
        if ($data['id'] == '') {

          if(get_option('contact_can_add_password') != 1){
            access_denied('team_password');
          }

          $data['add_by'] = 'contact';
          $data['add_from'] = get_contact_user_id();
          $data['password'] = $this->input->post('password' , false);
          $data['smtp_password'] = $this->input->post('smtp_password' , false);

          $insert_id = $this->team_password_model->add_email($data);
          if ($insert_id) {
            $success = true;
            $message = _l('added_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=email'));
        } else {
          $data['password'] = $this->input->post('password' , false);
          $data['smtp_password'] = $this->input->post('smtp_password' , false);
          $success = $this->team_password_model->update_email($data);
          if ($success) {
            $message = _l('updated_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=email'));
        }
        die;
      }

      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
      $this->data($data);
      $this->view('team_password_mgt/client/edit_email_client');
      $this->layout();
    }
               /**
     * add server
     * @param id
     * @return redirect
     */
     public function add_server($id = '')
     { 
      if (!is_client_logged_in()) {
        redirect(site_url('authentication/login'));
      }

      $cate = $this->input->get('cate');

      if($cate != 'all' && $cate != ''){
        $data['cate'] = $cate;
      }else{
        $data['cate'] = '';
      }

      $data['title'] = _l('add_server');
      if ($this->input->post()) {
        $message          = '';
        $data             = $this->input->post();
        $data['enable_log'] = 'on';
        if ($data['id'] == '') {

          if(get_option('contact_can_add_password') != 1){
            access_denied('team_password');
          }

          $data['add_by'] = 'contact';
          $data['add_from'] = get_contact_user_id();
          $data['password'] = $this->input->post('password' , false);

          $insert_id = $this->team_password_model->add_server($data);
          if ($insert_id) {
            $success = true;
            $message = _l('added_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=server'));
        } else {
          $data['password'] = $this->input->post('password' , false);
          $success = $this->team_password_model->update_server($data);
          if ($success) {
            $message = _l('updated_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=server'));
        }
        die;
      }

      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
      $this->data($data);
      $this->view('team_password_mgt/client/edit_server_client');
      $this->layout();
    }
     /**
     * add software license
     * @param int id
     * @return redirect
     */
     public function add_software_license($id = '')
     {   
      if (!is_client_logged_in()) {
        redirect(site_url('authentication/login'));
      }

      $cate = $this->input->get('cate');

      if($cate != 'all' && $cate != ''){
        $data['cate'] = $cate;
      }else{
        $data['cate'] = '';
      }

      $data['title'] = _l('add_software_license');
      if ($this->input->post()) {
        $message          = '';
        $data             = $this->input->post();
        $data['enable_log'] = 'on';
        if ($data['id'] == '') {

          if(get_option('contact_can_add_password') != 1){
            access_denied('team_password');
          }

          $data['add_by'] = 'contact';
          $data['add_from'] = get_contact_user_id();

          $insert_id = $this->team_password_model->add_software_license($data);
          if ($insert_id) {
            $success = true;
            $message = _l('added_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=software_license'));
        } else {
          $success = $this->team_password_model->update_software_license($data);
          if ($success) {
            $message = _l('updated_successfully');
            set_alert('success', $message);
          }
          redirect(site_url('team_password/team_password_client/team_password_mgt?cate='.$data['mgt_id'].'&type=software_license'));
        }
        die;
      }

      $data['category'] = $this->team_password_model->get_category_by_contact(get_contact_user_id(), get_client_user_id());
      $this->data($data);
      $this->view('team_password_mgt/client/edit_software_license_client');
      $this->layout();
    }

    /**
     * { file item }
     *
     * @param        $id      The identifier
     * @param        $rel_id  The relative identifier
     */
    public function file_item($id, $rel_id, $type)
    {
      $data['discussion_user_profile_image_url'] = staff_profile_image_url(get_staff_user_id());
      $data['current_user_is_admin']             = is_admin();
      $data['file'] = $this->team_password_model->get_file($id, $rel_id);
      $data['types'] = $type;
      if (!$data['file']) {
        header('HTTP/1.0 404 Not Found');
        die;
      }
      $this->load->view('team_password_mgt/_file', $data);
    }
  }