/*
 Highcharts JS v8.2.2 (2020-10-22)

 3D features for Highcharts JS

 License: www.highcharts.com/license
*/
(function(b){"object"===typeof module&&module.exports?(b["default"]=b,module.exports=b):"function"===typeof define&&define.amd?define("highcharts/highcharts-3d",["highcharts"],function(G){b(G);b.Highcharts=G;return b}):b("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(b){function G(b,u,w,J){b.hasOwnProperty(u)||(b[u]=J.apply(null,w))}b=b?b._modules:{};G(b,"Extensions/Math3D.js",[b["Core/Globals.js"],b["Core/Utilities.js"]],function(b,u){var w=u.pick,y=b.deg2rad,c=b.perspective3D=function(c,
n,f){n=0<f&&f<Number.POSITIVE_INFINITY?f/(c.z+n.z+f):1;return{x:c.x*n,y:c.y*n}},x=b.perspective=function(q,n,f,r){var m=n.options.chart.options3d,b=w(r,f?n.inverted:!1),h={x:n.plotWidth/2,y:n.plotHeight/2,z:m.depth/2,vd:w(m.depth,1)*w(m.viewDistance,0)},k=n.scale3d||1;r=y*m.beta*(b?-1:1);m=y*m.alpha*(b?-1:1);var a=Math.cos(m),g=Math.cos(-r),C=Math.sin(m),d=Math.sin(-r);f||(h.x+=n.plotLeft,h.y+=n.plotTop);return q.map(function(p){var f=(b?p.y:p.x)-h.x;var m=(b?p.x:p.y)-h.y;p=(p.z||0)-h.z;f={x:g*f-
d*p,y:-C*d*f+a*m-g*C*p,z:a*d*f+C*m+a*g*p};m=c(f,h,h.vd);m.x=m.x*k+h.x;m.y=m.y*k+h.y;m.z=f.z*k+h.z;return{x:b?m.y:m.x,y:b?m.x:m.y,z:m.z}})};u=b.pointCameraDistance=function(c,b){var f=b.options.chart.options3d,r=b.plotWidth/2;b=b.plotHeight/2;f=w(f.depth,1)*w(f.viewDistance,0)+f.depth;return Math.sqrt(Math.pow(r-w(c.plotX,c.x),2)+Math.pow(b-w(c.plotY,c.y),2)+Math.pow(f-w(c.plotZ,c.z),2))};var h=b.shapeArea=function(c){var b=0,f;for(f=0;f<c.length;f++){var r=(f+1)%c.length;b+=c[f].x*c[r].y-c[r].x*c[f].y}return b/
2};b=b.shapeArea3d=function(c,b,f){return h(x(c,b,f))};return{perspective:x,perspective3D:c,pointCameraDistance:u,shapeArea:h,shapeArea3D:b}});G(b,"Core/Renderer/SVG/SVGRenderer3D.js",[b["Core/Animation/AnimationUtilities.js"],b["Core/Color/Color.js"],b["Core/Globals.js"],b["Extensions/Math3D.js"],b["Core/Renderer/SVG/SVGElement.js"],b["Core/Renderer/SVG/SVGRenderer.js"],b["Core/Utilities.js"]],function(b,u,w,J,c,x,h){function q(a,d,e,K,g,l,c,t){var z=[],v=l-g;return l>g&&l-g>Math.PI/2+.0001?(z=z.concat(q(a,
d,e,K,g,g+Math.PI/2,c,t)),z=z.concat(q(a,d,e,K,g+Math.PI/2,l,c,t))):l<g&&g-l>Math.PI/2+.0001?(z=z.concat(q(a,d,e,K,g,g-Math.PI/2,c,t)),z=z.concat(q(a,d,e,K,g-Math.PI/2,l,c,t))):[["C",a+e*Math.cos(g)-e*F*v*Math.sin(g)+c,d+K*Math.sin(g)+K*F*v*Math.cos(g)+t,a+e*Math.cos(l)+e*F*v*Math.sin(l)+c,d+K*Math.sin(l)-K*F*v*Math.cos(l)+t,a+e*Math.cos(l)+c,d+K*Math.sin(l)+t]]}var n=b.animObject,f=u.parse,r=J.perspective,m=J.shapeArea,A=h.defined,y=h.extend,k=h.merge,a=h.objectEach,g=h.pick,C=Math.cos,d=Math.PI,
p=Math.sin,I=w.charts,L=w.deg2rad;var F=4*(Math.sqrt(2)-1)/3/(d/2);x.prototype.toLinePath=function(a,d){var e=[];a.forEach(function(a){e.push(["L",a.x,a.y])});a.length&&(e[0][0]="M",d&&e.push(["Z"]));return e};x.prototype.toLineSegments=function(a){var d=[],e=!0;a.forEach(function(a){d.push(e?["M",a.x,a.y]:["L",a.x,a.y]);e=!e});return d};x.prototype.face3d=function(a){var d=this,e=this.createElement("path");e.vertexes=[];e.insidePlotArea=!1;e.enabled=!0;e.attr=function(a){if("object"===typeof a&&
(A(a.enabled)||A(a.vertexes)||A(a.insidePlotArea))){this.enabled=g(a.enabled,this.enabled);this.vertexes=g(a.vertexes,this.vertexes);this.insidePlotArea=g(a.insidePlotArea,this.insidePlotArea);delete a.enabled;delete a.vertexes;delete a.insidePlotArea;var e=r(this.vertexes,I[d.chartIndex],this.insidePlotArea),l=d.toLinePath(e,!0);e=m(e);e=this.enabled&&0<e?"visible":"hidden";a.d=l;a.visibility=e}return c.prototype.attr.apply(this,arguments)};e.animate=function(a){if("object"===typeof a&&(A(a.enabled)||
A(a.vertexes)||A(a.insidePlotArea))){this.enabled=g(a.enabled,this.enabled);this.vertexes=g(a.vertexes,this.vertexes);this.insidePlotArea=g(a.insidePlotArea,this.insidePlotArea);delete a.enabled;delete a.vertexes;delete a.insidePlotArea;var e=r(this.vertexes,I[d.chartIndex],this.insidePlotArea),l=d.toLinePath(e,!0);e=m(e);e=this.enabled&&0<e?"visible":"hidden";a.d=l;this.attr("visibility",e)}return c.prototype.animate.apply(this,arguments)};return e.attr(a)};x.prototype.polyhedron=function(a){var d=
this,e=this.g(),g=e.destroy;this.styledMode||e.attr({"stroke-linejoin":"round"});e.faces=[];e.destroy=function(){for(var a=0;a<e.faces.length;a++)e.faces[a].destroy();return g.call(this)};e.attr=function(a,l,g,t){if("object"===typeof a&&A(a.faces)){for(;e.faces.length>a.faces.length;)e.faces.pop().destroy();for(;e.faces.length<a.faces.length;)e.faces.push(d.face3d().add(e));for(var z=0;z<a.faces.length;z++)d.styledMode&&delete a.faces[z].fill,e.faces[z].attr(a.faces[z],null,g,t);delete a.faces}return c.prototype.attr.apply(this,
arguments)};e.animate=function(a,l,g){if(a&&a.faces){for(;e.faces.length>a.faces.length;)e.faces.pop().destroy();for(;e.faces.length<a.faces.length;)e.faces.push(d.face3d().add(e));for(var t=0;t<a.faces.length;t++)e.faces[t].animate(a.faces[t],l,g);delete a.faces}return c.prototype.animate.apply(this,arguments)};return e.attr(a)};b={initArgs:function(a){var d=this,e=d.renderer,g=e[d.pathType+"Path"](a),c=g.zIndexes;d.parts.forEach(function(a){d[a]=e.path(g[a]).attr({"class":"highcharts-3d-"+a,zIndex:c[a]||
0}).add(d)});d.attr({"stroke-linejoin":"round",zIndex:c.group});d.originalDestroy=d.destroy;d.destroy=d.destroyParts;d.forcedSides=g.forcedSides},singleSetterForParts:function(d,g,e,c,p,l){var b={};c=[null,null,c||"attr",p,l];var t=e&&e.zIndexes;e?(t&&t.group&&this.attr({zIndex:t.group}),a(e,function(a,v){b[v]={};b[v][d]=a;t&&(b[v].zIndex=e.zIndexes[v]||0)}),c[1]=b):(b[d]=g,c[0]=b);return this.processParts.apply(this,c)},processParts:function(a,d,e,c,p){var l=this;l.parts.forEach(function(b){d&&(a=
g(d[b],!1));if(!1!==a)l[b][e](a,c,p)});return l},destroyParts:function(){this.processParts(null,null,"destroy");return this.originalDestroy()}};var H=k(b,{parts:["front","top","side"],pathType:"cuboid",attr:function(a,d,e,g){if("string"===typeof a&&"undefined"!==typeof d){var p=a;a={};a[p]=d}return a.shapeArgs||A(a.x)?this.singleSetterForParts("d",null,this.renderer[this.pathType+"Path"](a.shapeArgs||a)):c.prototype.attr.call(this,a,void 0,e,g)},animate:function(a,d,e){if(A(a.x)&&A(a.y)){a=this.renderer[this.pathType+
"Path"](a);var g=a.forcedSides;this.singleSetterForParts("d",null,a,"animate",d,e);this.attr({zIndex:a.zIndexes.group});g!==this.forcedSides&&(this.forcedSides=g,H.fillSetter.call(this,this.fill))}else c.prototype.animate.call(this,a,d,e);return this},fillSetter:function(a){this.forcedSides=this.forcedSides||[];this.singleSetterForParts("fill",null,{front:a,top:f(a).brighten(0<=this.forcedSides.indexOf("top")?0:.1).get(),side:f(a).brighten(0<=this.forcedSides.indexOf("side")?0:-.1).get()});this.color=
this.fill=a;return this}});x.prototype.elements3d={base:b,cuboid:H};x.prototype.element3d=function(a,d){var e=this.g();y(e,this.elements3d[a]);e.initArgs(d);return e};x.prototype.cuboid=function(a){return this.element3d("cuboid",a)};x.prototype.cuboidPath=function(a){function d(a){return 0===p&&1<a&&6>a?{x:E[a].x,y:E[a].y+10,z:E[a].z}:E[0].x===E[7].x&&4<=a?{x:E[a].x+10,y:E[a].y,z:E[a].z}:0===z&&2>a||5<a?{x:E[a].x,y:E[a].y,z:E[a].z+10}:E[a]}function e(a){return E[a]}var g=a.x,c=a.y,l=a.z||0,p=a.height,
t=a.width,z=a.depth,v=I[this.chartIndex],B=v.options.chart.options3d.alpha,b=0,E=[{x:g,y:c,z:l},{x:g+t,y:c,z:l},{x:g+t,y:c+p,z:l},{x:g,y:c+p,z:l},{x:g,y:c+p,z:l+z},{x:g+t,y:c+p,z:l+z},{x:g+t,y:c,z:l+z},{x:g,y:c,z:l+z}],f=[];E=r(E,v,a.insidePlotArea);var D=function(a,v,g){var c=[[],-1],l=a.map(e),B=v.map(e);a=a.map(d);v=v.map(d);0>m(l)?c=[l,0]:0>m(B)?c=[B,1]:g&&(f.push(g),c=0>m(a)?[l,0]:0>m(v)?[B,1]:[l,0]);return c};var C=D([3,2,1,0],[7,6,5,4],"front");a=C[0];var k=C[1];C=D([1,6,7,0],[4,5,2,3],"top");
t=C[0];var F=C[1];C=D([1,2,5,6],[0,7,4,3],"side");D=C[0];C=C[1];1===C?b+=1E6*(v.plotWidth-g):C||(b+=1E6*g);b+=10*(!F||0<=B&&180>=B||360>B&&357.5<B?v.plotHeight-c:10+c);1===k?b+=100*l:k||(b+=100*(1E3-l));return{front:this.toLinePath(a,!0),top:this.toLinePath(t,!0),side:this.toLinePath(D,!0),zIndexes:{group:Math.round(b)},forcedSides:f,isFront:k,isTop:F}};x.prototype.arc3d=function(a){function d(a){var d=!1,e={},g;a=k(a);for(g in a)-1!==b.indexOf(g)&&(e[g]=a[g],delete a[g],d=!0);return d?[e,a]:!1}var e=
this.g(),p=e.renderer,b="x y r innerR start end depth".split(" ");a=k(a);a.alpha=(a.alpha||0)*L;a.beta=(a.beta||0)*L;e.top=p.path();e.side1=p.path();e.side2=p.path();e.inn=p.path();e.out=p.path();e.onAdd=function(){var a=e.parentGroup,d=e.attr("class");e.top.add(e);["out","inn","side1","side2"].forEach(function(g){e[g].attr({"class":d+" highcharts-3d-side"}).add(a)})};["addClass","removeClass"].forEach(function(a){e[a]=function(){var d=arguments;["top","out","inn","side1","side2"].forEach(function(g){e[g][a].apply(e[g],
d)})}});e.setPaths=function(a){var d=e.renderer.arc3dPath(a),g=100*d.zTop;e.attribs=a;e.top.attr({d:d.top,zIndex:d.zTop});e.inn.attr({d:d.inn,zIndex:d.zInn});e.out.attr({d:d.out,zIndex:d.zOut});e.side1.attr({d:d.side1,zIndex:d.zSide1});e.side2.attr({d:d.side2,zIndex:d.zSide2});e.zIndex=g;e.attr({zIndex:g});a.center&&(e.top.setRadialReference(a.center),delete a.center)};e.setPaths(a);e.fillSetter=function(a){var d=f(a).brighten(-.1).get();this.fill=a;this.side1.attr({fill:d});this.side2.attr({fill:d});
this.inn.attr({fill:d});this.out.attr({fill:d});this.top.attr({fill:a});return this};["opacity","translateX","translateY","visibility"].forEach(function(a){e[a+"Setter"]=function(a,d){e[d]=a;["out","inn","side1","side2","top"].forEach(function(g){e[g].attr(d,a)})}});e.attr=function(a){var g;if("object"===typeof a&&(g=d(a))){var p=g[0];arguments[0]=g[1];y(e.attribs,p);e.setPaths(e.attribs)}return c.prototype.attr.apply(e,arguments)};e.animate=function(a,p,b){var z=this.attribs,v="data-"+Math.random().toString(26).substring(2,
9);delete a.center;delete a.z;delete a.alpha;delete a.beta;var B=n(g(p,this.renderer.globalAnimation));if(B.duration){p=d(a);e[v]=0;a[v]=1;e[v+"Setter"]=w.noop;if(p){var l=p[0];B.step=function(a,d){function e(a){return z[a]+(g(l[a],z[a])-z[a])*d.pos}d.prop===v&&d.elem.setPaths(k(z,{x:e("x"),y:e("y"),r:e("r"),innerR:e("innerR"),start:e("start"),end:e("end"),depth:e("depth")}))}}p=B}return c.prototype.animate.call(this,a,p,b)};e.destroy=function(){this.top.destroy();this.out.destroy();this.inn.destroy();
this.side1.destroy();this.side2.destroy();return c.prototype.destroy.call(this)};e.hide=function(){this.top.hide();this.out.hide();this.inn.hide();this.side1.hide();this.side2.hide()};e.show=function(a){this.top.show(a);this.out.show(a);this.inn.show(a);this.side1.show(a);this.side2.show(a)};return e};x.prototype.arc3dPath=function(a){function g(a){a%=2*Math.PI;a>Math.PI&&(a=2*Math.PI-a);return a}var e=a.x,c=a.y,b=a.start,l=a.end-.00001,f=a.r,t=a.innerR||0,z=a.depth||0,v=a.alpha,B=a.beta,m=Math.cos(b),
E=Math.sin(b);a=Math.cos(l);var k=Math.sin(l),D=f*Math.cos(B);f*=Math.cos(v);var F=t*Math.cos(B),r=t*Math.cos(v);t=z*Math.sin(B);var h=z*Math.sin(v);z=[["M",e+D*m,c+f*E]];z=z.concat(q(e,c,D,f,b,l,0,0));z.push(["L",e+F*a,c+r*k]);z=z.concat(q(e,c,F,r,l,b,0,0));z.push(["Z"]);var n=0<B?Math.PI/2:0;B=0<v?0:Math.PI/2;n=b>-n?b:l>-n?-n:b;var H=l<d-B?l:b<d-B?d-B:l,I=2*d-B;v=[["M",e+D*C(n),c+f*p(n)]];v=v.concat(q(e,c,D,f,n,H,0,0));l>I&&b<I?(v.push(["L",e+D*C(H)+t,c+f*p(H)+h]),v=v.concat(q(e,c,D,f,H,I,t,h)),
v.push(["L",e+D*C(I),c+f*p(I)]),v=v.concat(q(e,c,D,f,I,l,0,0)),v.push(["L",e+D*C(l)+t,c+f*p(l)+h]),v=v.concat(q(e,c,D,f,l,I,t,h)),v.push(["L",e+D*C(I),c+f*p(I)]),v=v.concat(q(e,c,D,f,I,H,0,0))):l>d-B&&b<d-B&&(v.push(["L",e+D*Math.cos(H)+t,c+f*Math.sin(H)+h]),v=v.concat(q(e,c,D,f,H,l,t,h)),v.push(["L",e+D*Math.cos(l),c+f*Math.sin(l)]),v=v.concat(q(e,c,D,f,l,H,0,0)));v.push(["L",e+D*Math.cos(H)+t,c+f*Math.sin(H)+h]);v=v.concat(q(e,c,D,f,H,n,t,h));v.push(["Z"]);B=[["M",e+F*m,c+r*E]];B=B.concat(q(e,c,
F,r,b,l,0,0));B.push(["L",e+F*Math.cos(l)+t,c+r*Math.sin(l)+h]);B=B.concat(q(e,c,F,r,l,b,t,h));B.push(["Z"]);m=[["M",e+D*m,c+f*E],["L",e+D*m+t,c+f*E+h],["L",e+F*m+t,c+r*E+h],["L",e+F*m,c+r*E],["Z"]];e=[["M",e+D*a,c+f*k],["L",e+D*a+t,c+f*k+h],["L",e+F*a+t,c+r*k+h],["L",e+F*a,c+r*k],["Z"]];k=Math.atan2(h,-t);c=Math.abs(l+k);a=Math.abs(b+k);b=Math.abs((b+l)/2+k);c=g(c);a=g(a);b=g(b);b*=1E5;l=1E5*a;c*=1E5;return{top:z,zTop:1E5*Math.PI+1,out:v,zOut:Math.max(b,l,c),inn:B,zInn:Math.max(b,l,c),side1:m,zSide1:.99*
c,side2:e,zSide2:.99*l}};return x});G(b,"Core/Axis/Tick3D.js",[b["Core/Utilities.js"]],function(b){var u=b.addEvent,w=b.extend,y=b.wrap;return function(){function c(){}c.compose=function(b){u(b,"afterGetLabelPosition",c.onAfterGetLabelPosition);y(b.prototype,"getMarkPath",c.wrapGetMarkPath)};c.onAfterGetLabelPosition=function(c){var b=this.axis.axis3D;b&&w(c.pos,b.fix3dPosition(c.pos))};c.wrapGetMarkPath=function(c){var b=this.axis.axis3D,q=c.apply(this,[].slice.call(arguments,1));if(b){var n=q[0],
f=q[1];if("M"===n[0]&&"L"===f[0])return b=[b.fix3dPosition({x:n[1],y:n[2],z:0}),b.fix3dPosition({x:f[1],y:f[2],z:0})],this.axis.chart.renderer.toLineSegments(b)}return q};return c}()});G(b,"Core/Axis/Axis3D.js",[b["Core/Globals.js"],b["Extensions/Math3D.js"],b["Core/Axis/Tick.js"],b["Core/Axis/Tick3D.js"],b["Core/Utilities.js"]],function(b,u,w,J,c){var x=u.perspective,h=u.perspective3D,q=u.shapeArea,n=c.addEvent,f=c.merge,r=c.pick,m=c.wrap,A=b.deg2rad,y=function(){function c(a){this.axis=a}c.prototype.fix3dPosition=
function(a,c){var g=this.axis,d=g.chart;if("colorAxis"===g.coll||!d.chart3d||!d.is3d())return a;var b=A*d.options.chart.options3d.alpha,f=A*d.options.chart.options3d.beta,m=r(c&&g.options.title.position3d,g.options.labels.position3d);c=r(c&&g.options.title.skew3d,g.options.labels.skew3d);var k=d.chart3d.frame3d,h=d.plotLeft,n=d.plotWidth+h,u=d.plotTop,e=d.plotHeight+u;d=!1;var w=0,y=0,l={x:0,y:1,z:0};a=g.axis3D.swapZ({x:a.x,y:a.y,z:0});if(g.isZAxis)if(g.opposite){if(null===k.axes.z.top)return{};y=
a.y-u;a.x=k.axes.z.top.x;a.y=k.axes.z.top.y;h=k.axes.z.top.xDir;d=!k.top.frontFacing}else{if(null===k.axes.z.bottom)return{};y=a.y-e;a.x=k.axes.z.bottom.x;a.y=k.axes.z.bottom.y;h=k.axes.z.bottom.xDir;d=!k.bottom.frontFacing}else if(g.horiz)if(g.opposite){if(null===k.axes.x.top)return{};y=a.y-u;a.y=k.axes.x.top.y;a.z=k.axes.x.top.z;h=k.axes.x.top.xDir;d=!k.top.frontFacing}else{if(null===k.axes.x.bottom)return{};y=a.y-e;a.y=k.axes.x.bottom.y;a.z=k.axes.x.bottom.z;h=k.axes.x.bottom.xDir;d=!k.bottom.frontFacing}else if(g.opposite){if(null===
k.axes.y.right)return{};w=a.x-n;a.x=k.axes.y.right.x;a.z=k.axes.y.right.z;h=k.axes.y.right.xDir;h={x:h.z,y:h.y,z:-h.x}}else{if(null===k.axes.y.left)return{};w=a.x-h;a.x=k.axes.y.left.x;a.z=k.axes.y.left.z;h=k.axes.y.left.xDir}"chart"!==m&&("flap"===m?g.horiz?(f=Math.sin(b),b=Math.cos(b),g.opposite&&(f=-f),d&&(f=-f),l={x:h.z*f,y:b,z:-h.x*f}):h={x:Math.cos(f),y:0,z:Math.sin(f)}:"ortho"===m?g.horiz?(l=Math.cos(b),m=Math.sin(f)*l,b=-Math.sin(b),f=-l*Math.cos(f),l={x:h.y*f-h.z*b,y:h.z*m-h.x*f,z:h.x*b-
h.y*m},b=1/Math.sqrt(l.x*l.x+l.y*l.y+l.z*l.z),d&&(b=-b),l={x:b*l.x,y:b*l.y,z:b*l.z}):h={x:Math.cos(f),y:0,z:Math.sin(f)}:g.horiz?l={x:Math.sin(f)*Math.sin(b),y:Math.cos(b),z:-Math.cos(f)*Math.sin(b)}:h={x:Math.cos(f),y:0,z:Math.sin(f)});a.x+=w*h.x+y*l.x;a.y+=w*h.y+y*l.y;a.z+=w*h.z+y*l.z;d=x([a],g.chart)[0];c&&(0>q(x([a,{x:a.x+h.x,y:a.y+h.y,z:a.z+h.z},{x:a.x+l.x,y:a.y+l.y,z:a.z+l.z}],g.chart))&&(h={x:-h.x,y:-h.y,z:-h.z}),a=x([{x:a.x,y:a.y,z:a.z},{x:a.x+h.x,y:a.y+h.y,z:a.z+h.z},{x:a.x+l.x,y:a.y+l.y,
z:a.z+l.z}],g.chart),d.matrix=[a[1].x-a[0].x,a[1].y-a[0].y,a[2].x-a[0].x,a[2].y-a[0].y,d.x,d.y],d.matrix[4]-=d.x*d.matrix[0]+d.y*d.matrix[2],d.matrix[5]-=d.x*d.matrix[1]+d.y*d.matrix[3]);return d};c.prototype.swapZ=function(a,g){var c=this.axis;return c.isZAxis?(g=g?0:c.chart.plotLeft,{x:g+a.z,y:a.y,z:a.x-g}):a};return c}();return function(){function c(){}c.compose=function(a){f(!0,a.defaultOptions,c.defaultOptions);a.keepProps.push("axis3D");n(a,"init",c.onInit);n(a,"afterSetOptions",c.onAfterSetOptions);
n(a,"drawCrosshair",c.onDrawCrosshair);n(a,"destroy",c.onDestroy);a=a.prototype;m(a,"getLinePath",c.wrapGetLinePath);m(a,"getPlotBandPath",c.wrapGetPlotBandPath);m(a,"getPlotLinePath",c.wrapGetPlotLinePath);m(a,"getSlotWidth",c.wrapGetSlotWidth);m(a,"getTitlePosition",c.wrapGetTitlePosition);J.compose(w)};c.onAfterSetOptions=function(){var a=this.chart,c=this.options;a.is3d&&a.is3d()&&"colorAxis"!==this.coll&&(c.tickWidth=r(c.tickWidth,0),c.gridLineWidth=r(c.gridLineWidth,1))};c.onDestroy=function(){["backFrame",
"bottomFrame","sideFrame"].forEach(function(a){this[a]&&(this[a]=this[a].destroy())},this)};c.onDrawCrosshair=function(a){this.chart.is3d()&&"colorAxis"!==this.coll&&a.point&&(a.point.crosshairPos=this.isXAxis?a.point.axisXpos:this.len-a.point.axisYpos)};c.onInit=function(){this.axis3D||(this.axis3D=new y(this))};c.wrapGetLinePath=function(a){return this.chart.is3d()&&"colorAxis"!==this.coll?[]:a.apply(this,[].slice.call(arguments,1))};c.wrapGetPlotBandPath=function(a){if(!this.chart.is3d()||"colorAxis"===
this.coll)return a.apply(this,[].slice.call(arguments,1));var c=arguments,b=c[2],d=[];c=this.getPlotLinePath({value:c[1]});b=this.getPlotLinePath({value:b});if(c&&b)for(var f=0;f<c.length;f+=2){var h=c[f],m=c[f+1],k=b[f],r=b[f+1];"M"===h[0]&&"L"===m[0]&&"M"===k[0]&&"L"===r[0]&&d.push(h,m,r,["L",k[1],k[2]],["Z"])}return d};c.wrapGetPlotLinePath=function(a){var c=this.axis3D,b=this.chart,d=a.apply(this,[].slice.call(arguments,1));if("colorAxis"===this.coll||!b.chart3d||!b.is3d()||null===d)return d;
var f=b.options.chart.options3d,h=this.isZAxis?b.plotWidth:f.depth;f=b.chart3d.frame3d;var m=d[0],k=d[1];d=[];"M"===m[0]&&"L"===k[0]&&(c=[c.swapZ({x:m[1],y:m[2],z:0}),c.swapZ({x:m[1],y:m[2],z:h}),c.swapZ({x:k[1],y:k[2],z:0}),c.swapZ({x:k[1],y:k[2],z:h})],this.horiz?(this.isZAxis?(f.left.visible&&d.push(c[0],c[2]),f.right.visible&&d.push(c[1],c[3])):(f.front.visible&&d.push(c[0],c[2]),f.back.visible&&d.push(c[1],c[3])),f.top.visible&&d.push(c[0],c[1]),f.bottom.visible&&d.push(c[2],c[3])):(f.front.visible&&
d.push(c[0],c[2]),f.back.visible&&d.push(c[1],c[3]),f.left.visible&&d.push(c[0],c[1]),f.right.visible&&d.push(c[2],c[3])),d=x(d,this.chart,!1));return b.renderer.toLineSegments(d)};c.wrapGetSlotWidth=function(a,c){var b=this.chart,d=this.ticks,f=this.gridGroup;if(this.categories&&b.frameShapes&&b.is3d()&&f&&c&&c.label){f=f.element.childNodes[0].getBBox();var g=b.frameShapes.left.getBBox(),m=b.options.chart.options3d;b={x:b.plotWidth/2,y:b.plotHeight/2,z:m.depth/2,vd:r(m.depth,1)*r(m.viewDistance,
0)};var k,n;m=c.pos;var q=d[m-1];d=d[m+1];0!==m&&q&&q.label.xy&&(k=h({x:q.label.xy.x,y:q.label.xy.y,z:null},b,b.vd));d&&d.label.xy&&(n=h({x:d.label.xy.x,y:d.label.xy.y,z:null},b,b.vd));d={x:c.label.xy.x,y:c.label.xy.y,z:null};d=h(d,b,b.vd);return Math.abs(k?d.x-k.x:n?n.x-d.x:f.x-g.x)}return a.apply(this,[].slice.call(arguments,1))};c.wrapGetTitlePosition=function(a){var c=a.apply(this,[].slice.call(arguments,1));return this.axis3D?this.axis3D.fix3dPosition(c,!0):c};c.defaultOptions={labels:{position3d:"offset",
skew3d:!1},title:{position3d:null,skew3d:null}};return c}()});G(b,"Core/Axis/ZAxis.js",[b["Core/Axis/Axis.js"],b["Core/Utilities.js"]],function(b,u){var w=this&&this.__extends||function(){var c=function(b,f){c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(c,b){c.__proto__=b}||function(c,b){for(var f in b)b.hasOwnProperty(f)&&(c[f]=b[f])};return c(b,f)};return function(b,f){function h(){this.constructor=b}c(b,f);b.prototype=null===f?Object.create(f):(h.prototype=f.prototype,new h)}}(),
y=u.addEvent,c=u.merge,x=u.pick,h=u.splat,q=function(){function c(){}c.compose=function(b){y(b,"afterGetAxes",c.onAfterGetAxes);b=b.prototype;b.addZAxis=c.wrapAddZAxis;b.collectionsWithInit.zAxis=[b.addZAxis];b.collectionsWithUpdate.push("zAxis")};c.onAfterGetAxes=function(){var c=this,b=this.options;b=b.zAxis=h(b.zAxis||{});c.is3d()&&(c.zAxis=[],b.forEach(function(b,f){b.index=f;b.isX=!0;c.addZAxis(b).setScale()}))};c.wrapAddZAxis=function(c){return new n(this,c)};return c}(),n=function(b){function f(c,
f){c=b.call(this,c,f)||this;c.isZAxis=!0;return c}w(f,b);f.prototype.getSeriesExtremes=function(){var c=this,b=c.chart;c.hasVisibleSeries=!1;c.dataMin=c.dataMax=c.ignoreMinPadding=c.ignoreMaxPadding=void 0;c.stacking&&c.stacking.buildStacks();c.series.forEach(function(f){!f.visible&&b.options.chart&&b.options.chart.ignoreHiddenSeries||(c.hasVisibleSeries=!0,f=f.zData,f.length&&(c.dataMin=Math.min(x(c.dataMin,f[0]),Math.min.apply(null,f)),c.dataMax=Math.max(x(c.dataMax,f[0]),Math.max.apply(null,f))))})};
f.prototype.setAxisSize=function(){var c=this.chart;b.prototype.setAxisSize.call(this);this.width=this.len=c.options.chart&&c.options.chart.options3d&&c.options.chart.options3d.depth||0;this.right=c.chartWidth-this.width-this.left};f.prototype.setOptions=function(f){f=c({offset:0,lineWidth:0},f);b.prototype.setOptions.call(this,f);this.coll="zAxis"};f.ZChartComposition=q;return f}(b);return n});G(b,"Core/Chart/Chart3D.js",[b["Core/Axis/Axis.js"],b["Core/Axis/Axis3D.js"],b["Core/Chart/Chart.js"],b["Core/Animation/Fx.js"],
b["Core/Globals.js"],b["Extensions/Math3D.js"],b["Core/Options.js"],b["Core/Utilities.js"],b["Core/Axis/ZAxis.js"]],function(b,u,w,J,c,x,h,q,n){var f=x.perspective,r=x.shapeArea3D,m=h.defaultOptions,A=q.addEvent,y=q.isArray,k=q.merge,a=q.pick,g=q.wrap,C;(function(b){function d(a){this.is3d()&&"scatter"===a.options.type&&(a.options.type="scatter3d")}function h(){if(this.chart3d&&this.is3d()){var a=this.renderer,b=this.options.chart.options3d,d=this.chart3d.get3dFrame(),f=this.plotLeft,e=this.plotLeft+
this.plotWidth,g=this.plotTop,h=this.plotTop+this.plotHeight;b=b.depth;var k=f-(d.left.visible?d.left.size:0),l=e+(d.right.visible?d.right.size:0),p=g-(d.top.visible?d.top.size:0),m=h+(d.bottom.visible?d.bottom.size:0),n=0-(d.front.visible?d.front.size:0),q=b+(d.back.visible?d.back.size:0),r=this.hasRendered?"animate":"attr";this.chart3d.frame3d=d;this.frameShapes||(this.frameShapes={bottom:a.polyhedron().add(),top:a.polyhedron().add(),left:a.polyhedron().add(),right:a.polyhedron().add(),back:a.polyhedron().add(),
front:a.polyhedron().add()});this.frameShapes.bottom[r]({"class":"highcharts-3d-frame highcharts-3d-frame-bottom",zIndex:d.bottom.frontFacing?-1E3:1E3,faces:[{fill:c.color(d.bottom.color).brighten(.1).get(),vertexes:[{x:k,y:m,z:n},{x:l,y:m,z:n},{x:l,y:m,z:q},{x:k,y:m,z:q}],enabled:d.bottom.visible},{fill:c.color(d.bottom.color).brighten(.1).get(),vertexes:[{x:f,y:h,z:b},{x:e,y:h,z:b},{x:e,y:h,z:0},{x:f,y:h,z:0}],enabled:d.bottom.visible},{fill:c.color(d.bottom.color).brighten(-.1).get(),vertexes:[{x:k,
y:m,z:n},{x:k,y:m,z:q},{x:f,y:h,z:b},{x:f,y:h,z:0}],enabled:d.bottom.visible&&!d.left.visible},{fill:c.color(d.bottom.color).brighten(-.1).get(),vertexes:[{x:l,y:m,z:q},{x:l,y:m,z:n},{x:e,y:h,z:0},{x:e,y:h,z:b}],enabled:d.bottom.visible&&!d.right.visible},{fill:c.color(d.bottom.color).get(),vertexes:[{x:l,y:m,z:n},{x:k,y:m,z:n},{x:f,y:h,z:0},{x:e,y:h,z:0}],enabled:d.bottom.visible&&!d.front.visible},{fill:c.color(d.bottom.color).get(),vertexes:[{x:k,y:m,z:q},{x:l,y:m,z:q},{x:e,y:h,z:b},{x:f,y:h,z:b}],
enabled:d.bottom.visible&&!d.back.visible}]});this.frameShapes.top[r]({"class":"highcharts-3d-frame highcharts-3d-frame-top",zIndex:d.top.frontFacing?-1E3:1E3,faces:[{fill:c.color(d.top.color).brighten(.1).get(),vertexes:[{x:k,y:p,z:q},{x:l,y:p,z:q},{x:l,y:p,z:n},{x:k,y:p,z:n}],enabled:d.top.visible},{fill:c.color(d.top.color).brighten(.1).get(),vertexes:[{x:f,y:g,z:0},{x:e,y:g,z:0},{x:e,y:g,z:b},{x:f,y:g,z:b}],enabled:d.top.visible},{fill:c.color(d.top.color).brighten(-.1).get(),vertexes:[{x:k,y:p,
z:q},{x:k,y:p,z:n},{x:f,y:g,z:0},{x:f,y:g,z:b}],enabled:d.top.visible&&!d.left.visible},{fill:c.color(d.top.color).brighten(-.1).get(),vertexes:[{x:l,y:p,z:n},{x:l,y:p,z:q},{x:e,y:g,z:b},{x:e,y:g,z:0}],enabled:d.top.visible&&!d.right.visible},{fill:c.color(d.top.color).get(),vertexes:[{x:k,y:p,z:n},{x:l,y:p,z:n},{x:e,y:g,z:0},{x:f,y:g,z:0}],enabled:d.top.visible&&!d.front.visible},{fill:c.color(d.top.color).get(),vertexes:[{x:l,y:p,z:q},{x:k,y:p,z:q},{x:f,y:g,z:b},{x:e,y:g,z:b}],enabled:d.top.visible&&
!d.back.visible}]});this.frameShapes.left[r]({"class":"highcharts-3d-frame highcharts-3d-frame-left",zIndex:d.left.frontFacing?-1E3:1E3,faces:[{fill:c.color(d.left.color).brighten(.1).get(),vertexes:[{x:k,y:m,z:n},{x:f,y:h,z:0},{x:f,y:h,z:b},{x:k,y:m,z:q}],enabled:d.left.visible&&!d.bottom.visible},{fill:c.color(d.left.color).brighten(.1).get(),vertexes:[{x:k,y:p,z:q},{x:f,y:g,z:b},{x:f,y:g,z:0},{x:k,y:p,z:n}],enabled:d.left.visible&&!d.top.visible},{fill:c.color(d.left.color).brighten(-.1).get(),
vertexes:[{x:k,y:m,z:q},{x:k,y:p,z:q},{x:k,y:p,z:n},{x:k,y:m,z:n}],enabled:d.left.visible},{fill:c.color(d.left.color).brighten(-.1).get(),vertexes:[{x:f,y:g,z:b},{x:f,y:h,z:b},{x:f,y:h,z:0},{x:f,y:g,z:0}],enabled:d.left.visible},{fill:c.color(d.left.color).get(),vertexes:[{x:k,y:m,z:n},{x:k,y:p,z:n},{x:f,y:g,z:0},{x:f,y:h,z:0}],enabled:d.left.visible&&!d.front.visible},{fill:c.color(d.left.color).get(),vertexes:[{x:k,y:p,z:q},{x:k,y:m,z:q},{x:f,y:h,z:b},{x:f,y:g,z:b}],enabled:d.left.visible&&!d.back.visible}]});
this.frameShapes.right[r]({"class":"highcharts-3d-frame highcharts-3d-frame-right",zIndex:d.right.frontFacing?-1E3:1E3,faces:[{fill:c.color(d.right.color).brighten(.1).get(),vertexes:[{x:l,y:m,z:q},{x:e,y:h,z:b},{x:e,y:h,z:0},{x:l,y:m,z:n}],enabled:d.right.visible&&!d.bottom.visible},{fill:c.color(d.right.color).brighten(.1).get(),vertexes:[{x:l,y:p,z:n},{x:e,y:g,z:0},{x:e,y:g,z:b},{x:l,y:p,z:q}],enabled:d.right.visible&&!d.top.visible},{fill:c.color(d.right.color).brighten(-.1).get(),vertexes:[{x:e,
y:g,z:0},{x:e,y:h,z:0},{x:e,y:h,z:b},{x:e,y:g,z:b}],enabled:d.right.visible},{fill:c.color(d.right.color).brighten(-.1).get(),vertexes:[{x:l,y:m,z:n},{x:l,y:p,z:n},{x:l,y:p,z:q},{x:l,y:m,z:q}],enabled:d.right.visible},{fill:c.color(d.right.color).get(),vertexes:[{x:l,y:p,z:n},{x:l,y:m,z:n},{x:e,y:h,z:0},{x:e,y:g,z:0}],enabled:d.right.visible&&!d.front.visible},{fill:c.color(d.right.color).get(),vertexes:[{x:l,y:m,z:q},{x:l,y:p,z:q},{x:e,y:g,z:b},{x:e,y:h,z:b}],enabled:d.right.visible&&!d.back.visible}]});
this.frameShapes.back[r]({"class":"highcharts-3d-frame highcharts-3d-frame-back",zIndex:d.back.frontFacing?-1E3:1E3,faces:[{fill:c.color(d.back.color).brighten(.1).get(),vertexes:[{x:l,y:m,z:q},{x:k,y:m,z:q},{x:f,y:h,z:b},{x:e,y:h,z:b}],enabled:d.back.visible&&!d.bottom.visible},{fill:c.color(d.back.color).brighten(.1).get(),vertexes:[{x:k,y:p,z:q},{x:l,y:p,z:q},{x:e,y:g,z:b},{x:f,y:g,z:b}],enabled:d.back.visible&&!d.top.visible},{fill:c.color(d.back.color).brighten(-.1).get(),vertexes:[{x:k,y:m,
z:q},{x:k,y:p,z:q},{x:f,y:g,z:b},{x:f,y:h,z:b}],enabled:d.back.visible&&!d.left.visible},{fill:c.color(d.back.color).brighten(-.1).get(),vertexes:[{x:l,y:p,z:q},{x:l,y:m,z:q},{x:e,y:h,z:b},{x:e,y:g,z:b}],enabled:d.back.visible&&!d.right.visible},{fill:c.color(d.back.color).get(),vertexes:[{x:f,y:g,z:b},{x:e,y:g,z:b},{x:e,y:h,z:b},{x:f,y:h,z:b}],enabled:d.back.visible},{fill:c.color(d.back.color).get(),vertexes:[{x:k,y:m,z:q},{x:l,y:m,z:q},{x:l,y:p,z:q},{x:k,y:p,z:q}],enabled:d.back.visible}]});this.frameShapes.front[r]({"class":"highcharts-3d-frame highcharts-3d-frame-front",
zIndex:d.front.frontFacing?-1E3:1E3,faces:[{fill:c.color(d.front.color).brighten(.1).get(),vertexes:[{x:k,y:m,z:n},{x:l,y:m,z:n},{x:e,y:h,z:0},{x:f,y:h,z:0}],enabled:d.front.visible&&!d.bottom.visible},{fill:c.color(d.front.color).brighten(.1).get(),vertexes:[{x:l,y:p,z:n},{x:k,y:p,z:n},{x:f,y:g,z:0},{x:e,y:g,z:0}],enabled:d.front.visible&&!d.top.visible},{fill:c.color(d.front.color).brighten(-.1).get(),vertexes:[{x:k,y:p,z:n},{x:k,y:m,z:n},{x:f,y:h,z:0},{x:f,y:g,z:0}],enabled:d.front.visible&&!d.left.visible},
{fill:c.color(d.front.color).brighten(-.1).get(),vertexes:[{x:l,y:m,z:n},{x:l,y:p,z:n},{x:e,y:g,z:0},{x:e,y:h,z:0}],enabled:d.front.visible&&!d.right.visible},{fill:c.color(d.front.color).get(),vertexes:[{x:e,y:g,z:0},{x:f,y:g,z:0},{x:f,y:h,z:0},{x:e,y:h,z:0}],enabled:d.front.visible},{fill:c.color(d.front.color).get(),vertexes:[{x:l,y:m,z:n},{x:k,y:m,z:n},{x:k,y:p,z:n},{x:l,y:p,z:n}],enabled:d.front.visible}]})}}function n(){this.styledMode&&(this.renderer.definition({tagName:"style",textContent:".highcharts-3d-top{filter: url(#highcharts-brighter)}\n.highcharts-3d-side{filter: url(#highcharts-darker)}\n"}),
[{name:"darker",slope:.6},{name:"brighter",slope:1.4}].forEach(function(a){this.renderer.definition({tagName:"filter",id:"highcharts-"+a.name,children:[{tagName:"feComponentTransfer",children:[{tagName:"feFuncR",type:"linear",slope:a.slope},{tagName:"feFuncG",type:"linear",slope:a.slope},{tagName:"feFuncB",type:"linear",slope:a.slope}]}]})},this))}function q(){var a=this.options;this.is3d()&&(a.series||[]).forEach(function(d){"scatter"===(d.type||a.chart.type||a.chart.defaultSeriesType)&&(d.type=
"scatter3d")})}function C(){var a=this.options.chart.options3d;if(this.chart3d&&this.is3d()){a&&(a.alpha=a.alpha%360+(0<=a.alpha?0:360),a.beta=a.beta%360+(0<=a.beta?0:360));var d=this.inverted,c=this.clipBox,b=this.margin;c[d?"y":"x"]=-(b[3]||0);c[d?"x":"y"]=-(b[0]||0);c[d?"height":"width"]=this.chartWidth+(b[3]||0)+(b[1]||0);c[d?"width":"height"]=this.chartHeight+(b[0]||0)+(b[2]||0);this.scale3d=1;!0===a.fitToPlot&&(this.scale3d=this.chart3d.getScale(a.depth));this.chart3d.frame3d=this.chart3d.get3dFrame()}}
function u(){this.is3d()&&(this.isDirtyBox=!0)}function w(){this.chart3d&&this.is3d()&&(this.chart3d.frame3d=this.chart3d.get3dFrame())}function e(){this.chart3d||(this.chart3d=new G(this))}function x(a){return this.is3d()||a.apply(this,[].slice.call(arguments,1))}function J(a){var d=this.series.length;if(this.is3d())for(;d--;)a=this.series[d],a.translate(),a.render();else a.call(this)}function l(a){a.apply(this,[].slice.call(arguments,1));this.is3d()&&(this.container.className+=" highcharts-3d-chart")}
var G=function(){function d(a){this.frame3d=void 0;this.chart=a}d.prototype.get3dFrame=function(){var d=this.chart,c=d.options.chart.options3d,b=c.frame,e=d.plotLeft,g=d.plotLeft+d.plotWidth,h=d.plotTop,k=d.plotTop+d.plotHeight,l=c.depth,p=function(a){a=r(a,d);return.5<a?1:-.5>a?-1:0},m=p([{x:e,y:k,z:l},{x:g,y:k,z:l},{x:g,y:k,z:0},{x:e,y:k,z:0}]),n=p([{x:e,y:h,z:0},{x:g,y:h,z:0},{x:g,y:h,z:l},{x:e,y:h,z:l}]),q=p([{x:e,y:h,z:0},{x:e,y:h,z:l},{x:e,y:k,z:l},{x:e,y:k,z:0}]),t=p([{x:g,y:h,z:l},{x:g,y:h,
z:0},{x:g,y:k,z:0},{x:g,y:k,z:l}]),C=p([{x:e,y:k,z:0},{x:g,y:k,z:0},{x:g,y:h,z:0},{x:e,y:h,z:0}]);p=p([{x:e,y:h,z:l},{x:g,y:h,z:l},{x:g,y:k,z:l},{x:e,y:k,z:l}]);var u=!1,F=!1,w=!1,y=!1;[].concat(d.xAxis,d.yAxis,d.zAxis).forEach(function(a){a&&(a.horiz?a.opposite?F=!0:u=!0:a.opposite?y=!0:w=!0)});var x=function(d,b,c){for(var e=["size","color","visible"],f={},g=0;g<e.length;g++)for(var h=e[g],k=0;k<d.length;k++)if("object"===typeof d[k]){var l=d[k][h];if("undefined"!==typeof l&&null!==l){f[h]=l;break}}d=
c;!0===f.visible||!1===f.visible?d=f.visible:"auto"===f.visible&&(d=0<b);return{size:a(f.size,1),color:a(f.color,"none"),frontFacing:0<b,visible:d}};b={axes:{},bottom:x([b.bottom,b.top,b],m,u),top:x([b.top,b.bottom,b],n,F),left:x([b.left,b.right,b.side,b],q,w),right:x([b.right,b.left,b.side,b],t,y),back:x([b.back,b.front,b],p,!0),front:x([b.front,b.back,b],C,!1)};"auto"===c.axisLabelPosition?(t=function(a,d){return a.visible!==d.visible||a.visible&&d.visible&&a.frontFacing!==d.frontFacing},c=[],t(b.left,
b.front)&&c.push({y:(h+k)/2,x:e,z:0,xDir:{x:1,y:0,z:0}}),t(b.left,b.back)&&c.push({y:(h+k)/2,x:e,z:l,xDir:{x:0,y:0,z:-1}}),t(b.right,b.front)&&c.push({y:(h+k)/2,x:g,z:0,xDir:{x:0,y:0,z:1}}),t(b.right,b.back)&&c.push({y:(h+k)/2,x:g,z:l,xDir:{x:-1,y:0,z:0}}),m=[],t(b.bottom,b.front)&&m.push({x:(e+g)/2,y:k,z:0,xDir:{x:1,y:0,z:0}}),t(b.bottom,b.back)&&m.push({x:(e+g)/2,y:k,z:l,xDir:{x:-1,y:0,z:0}}),n=[],t(b.top,b.front)&&n.push({x:(e+g)/2,y:h,z:0,xDir:{x:1,y:0,z:0}}),t(b.top,b.back)&&n.push({x:(e+g)/
2,y:h,z:l,xDir:{x:-1,y:0,z:0}}),q=[],t(b.bottom,b.left)&&q.push({z:(0+l)/2,y:k,x:e,xDir:{x:0,y:0,z:-1}}),t(b.bottom,b.right)&&q.push({z:(0+l)/2,y:k,x:g,xDir:{x:0,y:0,z:1}}),k=[],t(b.top,b.left)&&k.push({z:(0+l)/2,y:h,x:e,xDir:{x:0,y:0,z:-1}}),t(b.top,b.right)&&k.push({z:(0+l)/2,y:h,x:g,xDir:{x:0,y:0,z:1}}),e=function(a,b,c){if(0===a.length)return null;if(1===a.length)return a[0];for(var e=0,g=f(a,d,!1),h=1;h<g.length;h++)c*g[h][b]>c*g[e][b]?e=h:c*g[h][b]===c*g[e][b]&&g[h].z<g[e].z&&(e=h);return a[e]},
b.axes={y:{left:e(c,"x",-1),right:e(c,"x",1)},x:{top:e(n,"y",-1),bottom:e(m,"y",1)},z:{top:e(k,"y",-1),bottom:e(q,"y",1)}}):b.axes={y:{left:{x:e,z:0,xDir:{x:1,y:0,z:0}},right:{x:g,z:0,xDir:{x:0,y:0,z:1}}},x:{top:{y:h,z:0,xDir:{x:1,y:0,z:0}},bottom:{y:k,z:0,xDir:{x:1,y:0,z:0}}},z:{top:{x:w?g:e,y:h,xDir:w?{x:0,y:0,z:1}:{x:0,y:0,z:-1}},bottom:{x:w?g:e,y:k,xDir:w?{x:0,y:0,z:1}:{x:0,y:0,z:-1}}}};return b};d.prototype.getScale=function(a){var d=this.chart,b=d.plotLeft,c=d.plotWidth+b,e=d.plotTop,g=d.plotHeight+
e,h=b+d.plotWidth/2,k=e+d.plotHeight/2,l=Number.MAX_VALUE,p=-Number.MAX_VALUE,m=Number.MAX_VALUE,n=-Number.MAX_VALUE,q=1;var t=[{x:b,y:e,z:0},{x:b,y:e,z:a}];[0,1].forEach(function(a){t.push({x:c,y:t[a].y,z:t[a].z})});[0,1,2,3].forEach(function(a){t.push({x:t[a].x,y:g,z:t[a].z})});t=f(t,d,!1);t.forEach(function(a){l=Math.min(l,a.x);p=Math.max(p,a.x);m=Math.min(m,a.y);n=Math.max(n,a.y)});b>l&&(q=Math.min(q,1-Math.abs((b+h)/(l+h))%1));c<p&&(q=Math.min(q,(c-h)/(p-h)));e>m&&(q=0>m?Math.min(q,(e+k)/(-m+
e+k)):Math.min(q,1-(e+k)/(m+k)%1));g<n&&(q=Math.min(q,Math.abs((g-k)/(n-k))));return q};return d}();b.Composition=G;b.defaultOptions={chart:{options3d:{enabled:!1,alpha:0,beta:0,depth:100,fitToPlot:!0,viewDistance:25,axisLabelPosition:null,frame:{visible:"default",size:1,bottom:{},top:{},left:{},right:{},back:{},front:{}}}}};b.compose=function(a,f){var p=a.prototype;f=f.prototype;p.is3d=function(){return this.options.chart.options3d&&this.options.chart.options3d.enabled};p.propsRequireDirtyBox.push("chart.options3d");
p.propsRequireUpdateSeries.push("chart.options3d");f.matrixSetter=function(){if(1>this.pos&&(y(this.start)||y(this.end))){var a=this.start||[1,0,0,1,0,0],d=this.end||[1,0,0,1,0,0];var b=[];for(var c=0;6>c;c++)b.push(this.pos*d[c]+(1-this.pos)*a[c])}else b=this.end;this.elem.attr(this.prop,b,null,!0)};k(!0,m,b.defaultOptions);A(a,"init",e);A(a,"addSeries",d);A(a,"afterDrawChartBox",h);A(a,"afterGetContainer",n);A(a,"afterInit",q);A(a,"afterSetChartSize",C);A(a,"beforeRedraw",u);A(a,"beforeRender",
w);g(c.Chart.prototype,"isInsidePlot",x);g(a,"renderSeries",J);g(a,"setClassName",l)}})(C||(C={}));C.compose(w,J);n.ZChartComposition.compose(w);u.compose(b);"";return C});G(b,"Core/Series/Series3D.js",[b["Core/Globals.js"],b["Extensions/Math3D.js"],b["Core/Utilities.js"]],function(b,u,w){var y=u.perspective;u=w.addEvent;var c=w.pick;u(b.Series,"afterTranslate",function(){this.chart.is3d()&&this.translate3dPoints()});b.Series.prototype.translate3dPoints=function(){var b=this.chart,h=c(this.zAxis,
b.options.zAxis[0]),q=[],n;for(n=0;n<this.data.length;n++){var f=this.data[n];if(h&&h.translate){var r=h.logarithmic&&h.val2lin?h.val2lin(f.z):f.z;f.plotZ=h.translate(r);f.isInside=f.isInside?r>=h.min&&r<=h.max:!1}else f.plotZ=0;f.axisXpos=f.plotX;f.axisYpos=f.plotY;f.axisZpos=f.plotZ;q.push({x:f.plotX,y:f.plotY,z:f.plotZ})}b=y(q,b,!0);for(n=0;n<this.data.length;n++)f=this.data[n],h=b[n],f.plotX=h.x,f.plotY=h.y,f.plotZ=h.z}});G(b,"Series/Column3DSeries.js",[b["Core/Series/Series.js"],b["Core/Globals.js"],
b["Extensions/Math3D.js"],b["Extensions/Stacking.js"],b["Core/Utilities.js"]],function(b,u,w,J,c){function x(b,a){var c=b.series,f={},d,h=1;c.forEach(function(b){d=r(b.options.stack,a?0:c.length-1-b.index);f[d]?f[d].series.push(b):(f[d]={series:[b],position:h},h++)});f.totalStacks=h+1;return f}function h(b){var a=b.apply(this,[].slice.call(arguments,1));this.chart.is3d&&this.chart.is3d()&&(a.stroke=this.options.edgeColor||a.fill,a["stroke-width"]=r(this.options.edgeWidth,1));return a}function q(b,
a,c){var f=this.chart.is3d&&this.chart.is3d();f&&(this.options.inactiveOtherPoints=!0);b.call(this,a,c);f&&(this.options.inactiveOtherPoints=!1)}function n(b){for(var a=[],c=1;c<arguments.length;c++)a[c-1]=arguments[c];return this.series.chart.is3d()?this.graphic&&"g"!==this.graphic.element.nodeName:b.apply(this,a)}var f=w.perspective;w=c.addEvent;var r=c.pick;c=c.wrap;var m=u.Series,A=b.seriesTypes.column.prototype,y=u.svg;c(A,"translate",function(b){b.apply(this,[].slice.call(arguments,1));this.chart.is3d()&&
this.translate3dShapes()});c(m.prototype,"justifyDataLabel",function(b){return arguments[2].outside3dPlot?!1:b.apply(this,[].slice.call(arguments,1))});A.translate3dPoints=function(){};A.translate3dShapes=function(){var b=this,a=b.chart,c=b.options,h=c.depth,d=(c.stacking?c.stack||0:b.index)*(h+(c.groupZPadding||1)),p=b.borderWidth%2?.5:0,m;a.inverted&&!b.yAxis.reversed&&(p*=-1);!1!==c.grouping&&(d=0);d+=c.groupZPadding||1;b.data.forEach(function(c){c.outside3dPlot=null;if(null!==c.y){var g=c.shapeArgs,
k=c.tooltipPos,n;[["x","width"],["y","height"]].forEach(function(a){n=g[a[0]]-p;0>n&&(g[a[1]]+=g[a[0]]+p,g[a[0]]=-p,n=0);n+g[a[1]]>b[a[0]+"Axis"].len&&0!==g[a[1]]&&(g[a[1]]=b[a[0]+"Axis"].len-g[a[0]]);if(0!==g[a[1]]&&(g[a[0]]>=b[a[0]+"Axis"].len||g[a[0]]+g[a[1]]<=p)){for(var d in g)g[d]=0;c.outside3dPlot=!0}});"rect"===c.shapeType&&(c.shapeType="cuboid");g.z=d;g.depth=h;g.insidePlotArea=!0;m={x:g.x+g.width/2,y:g.y,z:d+h/2};a.inverted&&(m.x=g.height,m.y=c.clientX);c.plot3d=f([m],a,!0,!1)[0];k=f([{x:k[0],
y:k[1],z:d+h/2}],a,!0,!1)[0];c.tooltipPos=[k.x,k.y]}});b.z=d};c(A,"animate",function(b){if(this.chart.is3d()){var a=arguments[1],c=this.yAxis,f=this,d=this.yAxis.reversed;y&&(a?f.data.forEach(function(a){null!==a.y&&(a.height=a.shapeArgs.height,a.shapey=a.shapeArgs.y,a.shapeArgs.height=1,d||(a.shapeArgs.y=a.stackY?a.plotY+c.translate(a.stackY):a.plotY+(a.negative?-a.height:a.height)))}):(f.data.forEach(function(a){null!==a.y&&(a.shapeArgs.height=a.height,a.shapeArgs.y=a.shapey,a.graphic&&a.graphic.animate(a.shapeArgs,
f.options.animation))}),this.drawDataLabels()))}else b.apply(this,[].slice.call(arguments,1))});c(A,"plotGroup",function(b,a,c,f,d,h){"dataLabelsGroup"!==a&&this.chart.is3d()&&(this[a]&&delete this[a],h&&(this.chart.columnGroup||(this.chart.columnGroup=this.chart.renderer.g("columnGroup").add(h)),this[a]=this.chart.columnGroup,this.chart.columnGroup.attr(this.getPlotBox()),this[a].survive=!0,"group"===a||"markerGroup"===a))&&(arguments[3]="visible");return b.apply(this,Array.prototype.slice.call(arguments,
1))});c(A,"setVisible",function(b,a){var c=this,f;c.chart.is3d()&&c.data.forEach(function(b){f=(b.visible=b.options.visible=a="undefined"===typeof a?!r(c.visible,b.visible):a)?"visible":"hidden";c.options.data[c.data.indexOf(b)]=b.options;b.graphic&&b.graphic.attr({visibility:f})});b.apply(this,Array.prototype.slice.call(arguments,1))});A.handle3dGrouping=!0;w(m,"afterInit",function(){if(this.chart.is3d()&&this.handle3dGrouping){var b=this.options,a=b.grouping,c=b.stacking,f=r(this.yAxis.options.reversedStacks,
!0),d=0;if("undefined"===typeof a||a){a=x(this.chart,c);d=b.stack||0;for(c=0;c<a[d].series.length&&a[d].series[c]!==this;c++);d=10*(a.totalStacks-a[d].position)+(f?c:-c);this.xAxis.reversed||(d=10*a.totalStacks-d)}b.depth=b.depth||25;this.z=this.z||0;b.zIndex=d}});c(A,"pointAttribs",h);c(A,"setState",q);c(A.pointClass.prototype,"hasNewShapeType",n);b.seriesTypes.columnRange&&(u=b.seriesTypes.columnrange.prototype,c(u,"pointAttribs",h),c(u,"setState",q),c(u.pointClass.prototype,"hasNewShapeType",n),
u.plotGroup=A.plotGroup,u.setVisible=A.setVisible);c(m.prototype,"alignDataLabel",function(b,a,c,h,d){var g=this.chart;h.outside3dPlot=a.outside3dPlot;if(g.is3d()&&this.is("column")){var k=this.options,m=r(h.inside,!!this.options.stacking),n=g.options.chart.options3d,q=a.pointWidth/2||0;k={x:d.x+q,y:d.y,z:this.z+k.depth/2};g.inverted&&(m&&(d.width=0,k.x+=a.shapeArgs.height/2),90<=n.alpha&&270>=n.alpha&&(k.y+=a.shapeArgs.width));k=f([k],g,!0,!1)[0];d.x=k.x-q;d.y=a.outside3dPlot?-9E9:k.y}b.apply(this,
[].slice.call(arguments,1))});c(J.prototype,"getStackBox",function(c,a,g,h,d,m,n,q){var k=c.apply(this,[].slice.call(arguments,1));if(a.is3d()&&g.base){var p=+g.base.split(",")[0],r=a.series[p];p=a.options.chart.options3d;r&&r instanceof b.seriesTypes.column&&(r={x:k.x+(a.inverted?n:m/2),y:k.y,z:r.options.depth/2},a.inverted&&(k.width=0,90<=p.alpha&&270>=p.alpha&&(r.y+=m)),r=f([r],a,!0,!1)[0],k.x=r.x-m/2,k.y=r.y)}return k})});G(b,"Series/Pie3DSeries.js",[b["Core/Series/Series.js"],b["Core/Globals.js"],
b["Core/Utilities.js"]],function(b,u,w){var y=u.deg2rad,c=u.svg,x=w.pick;u=w.wrap;b=b.seriesTypes;u(b.pie.prototype,"translate",function(b){b.apply(this,[].slice.call(arguments,1));if(this.chart.is3d()){var c=this,h=c.options,f=h.depth||0,r=c.chart.options.chart.options3d,m=r.alpha,u=r.beta,w=h.stacking?(h.stack||0)*f:c._i*f;w+=f/2;!1!==h.grouping&&(w=0);c.data.forEach(function(b){var a=b.shapeArgs;b.shapeType="arc3d";a.z=w;a.depth=.75*f;a.alpha=m;a.beta=u;a.center=c.center;a=(a.end+a.start)/2;b.slicedTranslation=
{translateX:Math.round(Math.cos(a)*h.slicedOffset*Math.cos(m*y)),translateY:Math.round(Math.sin(a)*h.slicedOffset*Math.cos(m*y))}})}});u(b.pie.prototype.pointClass.prototype,"haloPath",function(b){var c=arguments;return this.series.chart.is3d()?[]:b.call(this,c[1])});u(b.pie.prototype,"pointAttribs",function(b,c,n){b=b.call(this,c,n);n=this.options;this.chart.is3d()&&!this.chart.styledMode&&(b.stroke=n.edgeColor||c.color||this.color,b["stroke-width"]=x(n.edgeWidth,1));return b});u(b.pie.prototype,
"drawDataLabels",function(b){if(this.chart.is3d()){var c=this.chart.options.chart.options3d;this.data.forEach(function(b){var f=b.shapeArgs,h=f.r,m=(f.start+f.end)/2;b=b.labelPosition;var n=b.connectorPosition,q=-h*(1-Math.cos((f.alpha||c.alpha)*y))*Math.sin(m),k=h*(Math.cos((f.beta||c.beta)*y)-1)*Math.cos(m);[b.natural,n.breakAt,n.touchingSliceAt].forEach(function(a){a.x+=k;a.y+=q})})}b.apply(this,[].slice.call(arguments,1))});u(b.pie.prototype,"addPoint",function(b){b.apply(this,[].slice.call(arguments,
1));this.chart.is3d()&&this.update(this.userOptions,!0)});u(b.pie.prototype,"animate",function(b){if(this.chart.is3d()){var h=arguments[1],n=this.options.animation,f=this.center,r=this.group,m=this.markerGroup;c&&(!0===n&&(n={}),h?(r.oldtranslateX=x(r.oldtranslateX,r.translateX),r.oldtranslateY=x(r.oldtranslateY,r.translateY),h={translateX:f[0],translateY:f[1],scaleX:.001,scaleY:.001},r.attr(h),m&&(m.attrSetters=r.attrSetters,m.attr(h))):(h={translateX:r.oldtranslateX,translateY:r.oldtranslateY,scaleX:1,
scaleY:1},r.animate(h,n),m&&m.animate(h,n)))}else b.apply(this,[].slice.call(arguments,1))})});G(b,"Series/Scatter3DSeries.js",[b["Core/Series/Series.js"],b["Extensions/Math3D.js"],b["Core/Series/Point.js"]],function(b,u,w){var y=b.seriesTypes,c=u.pointCameraDistance;b.seriesType("scatter3d","scatter",{tooltip:{pointFormat:"x: <b>{point.x}</b><br/>y: <b>{point.y}</b><br/>z: <b>{point.z}</b><br/>"}},{pointAttribs:function(b){var h=y.scatter.prototype.pointAttribs.apply(this,arguments);this.chart.is3d()&&
b&&(h.zIndex=c(b,this.chart));return h},axisTypes:["xAxis","yAxis","zAxis"],pointArrayMap:["x","y","z"],parallelArrays:["x","y","z"],directTouch:!0},{applyOptions:function(){w.prototype.applyOptions.apply(this,arguments);"undefined"===typeof this.z&&(this.z=0);return this}});""});G(b,"masters/highcharts-3d.src.js",[],function(){})});
//# sourceMappingURL=highcharts-3d.js.map