<?php

defined('BASEPATH') or exit('No direct script access allowed');
header('Content-Type: text/html; charset=utf-8');

class Login_attempt_guard extends AdminController
{
    /**
     * Constructor method.
     * Loads the necessary models for the module.
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('payment_modes_model');
        $this->load->model('settings_model');
        $this->load->model('login_attempts_guard_model');
    }
    /**
     * Manage module settings.
     * Updates the settings if POST data is submitted.
     */
    public function manage(){
        if ($this->input->post()) {
            $post_data = $this->input->post();
            $success = $this->settings_model->update($post_data);
            if ($success > 0) {
                set_alert('success', _l('settings_updated'));
                redirect(admin_url('login_attempt_guard/manage'));
            }
        }
        $data['title'] = _l('login_attempt_guard_manage');
        $this->load->view('manage',$data);
    }
    /**
     * Display a list of users locked out due to failed login attempts.
     * Restricted to admin users.
     */
    public function locked_list(){
     
        if (!is_admin()) {
            access_denied('requests');
        }
        $data['title'] = _l('locked_list');
        $data['users'] = $this->login_attempts_guard_model->all();
        $this->load->view('locked_list', $data);
    }
    /**
     * Display a list of client users locked out due to failed login attempts.
     * Restricted to admin users.
     */
   
    /**
     * Unlock a user by deleting their login attempt record.
     */
    public function unlock_staff(){
        $data = $this->input->post();
        return $this->login_attempts_guard_model->delete($data['id']);
    } 
}
