<?php
defined('BASEPATH') or exit('No direct script access allowed');


/**
 * Function to get browser and operating system information from the user agent string.
 *
 * @param string $user_agent The user agent string from the HTTP request header.
 * @return string A string containing the browser and OS information, formatted for display.
 */
function get_browser_info($user_agent) {
    $browser = 'Unknown Browser';
    $os = 'Unknown OS';

    // Check for OS
    if (strpos($user_agent, 'Linux') !== false) {
        $os = 'Linux';
    } elseif (strpos($user_agent, 'Windows') !== false) {
        $os = 'Windows';
    } elseif (strpos($user_agent, 'Macintosh') !== false) {
        $os = 'Mac OS';
    } // Add more OS checks as needed

    // Check for browser
    if (strpos($user_agent, 'Chrome') !== false) {
        $browser = 'Google Chrome';
    } elseif (strpos($user_agent, 'Firefox') !== false) {
        $browser = 'Mozilla Firefox';
    } elseif (strpos($user_agent, 'Safari') !== false) {
        $browser = 'Apple Safari';
    } // Add more browser checks as needed

    return _l('browser') .' : '.$browser.', '._l('os'). ' : ' .$os;
}


/**
 * Function to calculate the remaining lockout time based on the current time.
 *
 * @param string $locked_until The datetime string representing when the lockout period ends.
 * @return string The remaining lockout time in minutes or seconds, formatted for display.
 */
function display_calculate_remaining_time($locked_until)
{
    $current_time = date('Y-m-d H:i:s');
    // Convert the datetime strings to DateTime objects
    $locked_until_datetime = new DateTime($locked_until);
    $current_datetime = new DateTime($current_time);

    // Calculate the interval between the two DateTime objects
    $interval = $locked_until_datetime->diff($current_datetime);

    // Calculate the total remaining minutes
    $remaining_minutes = ($interval->i + ($interval->h * 60) + ($interval->days * 1440));
    $remaining_seconds = $interval->s;

    if ($remaining_minutes < 1) {
        // If less than a minute, return remaining seconds
        return $remaining_seconds .' '. _l(' seconds');
    } else {
        // Otherwise, return the remaining minutes
        return $remaining_minutes .' '._l(' minutes');
    }
}
