<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
   <div class="content">
      <div class="row">
         <div class="col-md-6 col-md-offset-3">
            <h4 class="tw-mt-0 tw-font-semibold tw-text-lg tw-text-neutral-700">
               <?php echo _l('login_attempt_guard') ?>
            </h4>
            <?php echo form_open($this->uri->uri_string()); ?>
            <div class="panel_s">
               <div class="panel-body">
                  <div class="form-group">
                     <label for="time_format" class="control-label"><?php echo _l('login_attempt_guard_functionality'); ?></label>
                     <select name="settings[login_attempt_guard_functionality]" id="time_format" class="form-control selectpicker" data-none-selected-text="<?php echo _l('dropdown_non_selected_tex'); ?>">
                        <option value="0" <?php if('0' == get_option('login_attempt_guard_functionality')){echo 'selected';} ?>><?php echo _l('de-active'); ?></option>
                        <option value="1" <?php if('1' == get_option('login_attempt_guard_functionality')){echo 'selected';} ?>><?php echo _l('active'); ?></option>
                     </select>
                  </div>
                  <hr />
                  <?php echo render_input('settings[allow_retries]', 'allow_retries', get_option('allow_retries'), 'number',['required'=>'required', 'min'=>1]); ?>
                  <hr>
                  <?php echo render_input('settings[minute_lockout]', 'minute_lockout', get_option('minute_lockout'), 'number',['required'=>'required', 'min'=>1]); ?>
               </div>
               <div class="panel-footer text-right">
                  <button class="btn btn-primary"
                     type="submit"><?php echo _l('Save'); ?></button>
               </div>
            </div>
            <?php echo form_close(); ?>
         </div>
      </div>
   </div>
</div>
<?php init_tail(); ?>
</html>